%------------------------------------------------------------------------------
% File     : CSR125^2 : TPTP v7.4.0. Released v4.1.0.
% Domain   : Commonsense Reasoning
% Problem  : Sue contradicts her likes
% Version  : Especial > Augmented > Especial.
% English  : Mary likes Bill and Sue likes Bill. During 2009 Sue didn't like 
%            anybody. During year 2009 we get a contradiction.

% Refs     : [Ben10] Benzmueller (2010), Email to Geoff Sutcliffe
% Source   : [Ben10]
% Names    : ef_7.tq_SUMO_sine [Ben10]

% Status   : Theorem
% Rating   : 0.00 v7.4.0, 0.11 v7.2.0, 0.00 v7.1.0, 0.12 v7.0.0, 0.29 v6.4.0, 0.33 v6.3.0, 0.40 v6.2.0, 0.29 v6.1.0, 0.86 v6.0.0, 0.43 v5.5.0, 0.50 v5.4.0, 0.60 v5.3.0, 0.80 v5.2.0, 1.00 v4.1.0
% Syntax   : Number of formulae    :  410 (   0 unit; 137 type;   0 defn)
%            Number of atoms       : 1329 (  23 equality; 349 variable)
%            Maximal formula depth :   15 (   4 average)
%            Number of connectives : 1010 (   0   ~;   5   |;  48   &; 890   @)
%                                         (   9 <=>;  58  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  210 ( 210   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :  143 ( 137   :;   0   =)
%            Number of variables   :  165 (   0 sgn; 159   !;   6   ?;   0   ^)
%                                         ( 165   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : This is a simple test problem for reasoning in/about SUMO.
%            Initally the problem has been hand generated in KIF syntax in
%            SigmaKEE and then automatically translated by Benzmueller's
%            KIF2TH0 translator into THF syntax.
%          : The translation has been applied in two modes: local and SInE.
%            The local mode only translates the local assumptions and the
%            query. The SInE mode additionally translates the SInE-extract
%            of the loaded knowledge base (usually SUMO).
%          : The examples are selected to illustrate the benefits of
%            higher-order reasoning in ontology reasoning.
%------------------------------------------------------------------------------
%----The extracted signature
thf(numbers,type,(
    num: $tType )).

thf(agent_THFTYPE_IiioI,type,(
    agent_THFTYPE_IiioI: $i > $i > $o )).

thf(attribute_THFTYPE_i,type,(
    attribute_THFTYPE_i: $i )).

thf(believes_THFTYPE_IiooI,type,(
    believes_THFTYPE_IiooI: $i > $o > $o )).

thf(containsInformation_THFTYPE_IiooI,type,(
    containsInformation_THFTYPE_IiooI: $i > $o > $o )).

thf(contraryAttribute_THFTYPE_IioI,type,(
    contraryAttribute_THFTYPE_IioI: $i > $o )).

thf(contraryAttribute_THFTYPE_IoooI,type,(
    contraryAttribute_THFTYPE_IoooI: $o > $o > $o )).

thf(disjointRelation_THFTYPE_IiioI,type,(
    disjointRelation_THFTYPE_IiioI: $i > $i > $o )).

thf(disjoint_THFTYPE_IiioI,type,(
    disjoint_THFTYPE_IiioI: $i > $i > $o )).

thf(documentation_THFTYPE_i,type,(
    documentation_THFTYPE_i: $i )).

thf(domainSubclass_THFTYPE_IIiiiIiioI,type,(
    domainSubclass_THFTYPE_IIiiiIiioI: ( $i > $i > $i ) > $i > $i > $o )).

thf(domainSubclass_THFTYPE_IIiioIiioI,type,(
    domainSubclass_THFTYPE_IIiioIiioI: ( $i > $i > $o ) > $i > $i > $o )).

thf(domainSubclass_THFTYPE_IIioIiioI,type,(
    domainSubclass_THFTYPE_IIioIiioI: ( $i > $o ) > $i > $i > $o )).

thf(domainSubclass_THFTYPE_IiiioI,type,(
    domainSubclass_THFTYPE_IiiioI: $i > $i > $i > $o )).

thf(domain_THFTYPE_IIIioIiioIiioI,type,(
    domain_THFTYPE_IIIioIiioIiioI: ( ( $i > $o ) > $i > $i > $o ) > $i > $i > $o )).

thf(domain_THFTYPE_IIiiIiioI,type,(
    domain_THFTYPE_IIiiIiioI: ( $i > $i ) > $i > $i > $o )).

thf(domain_THFTYPE_IIiiiIiioI,type,(
    domain_THFTYPE_IIiiiIiioI: ( $i > $i > $i ) > $i > $i > $o )).

thf(domain_THFTYPE_IIiiioIiioI,type,(
    domain_THFTYPE_IIiiioIiioI: ( $i > $i > $i > $o ) > $i > $i > $o )).

thf(domain_THFTYPE_IIiioIiioI,type,(
    domain_THFTYPE_IIiioIiioI: ( $i > $i > $o ) > $i > $i > $o )).

thf(domain_THFTYPE_IIioIiioI,type,(
    domain_THFTYPE_IIioIiioI: ( $i > $o ) > $i > $i > $o )).

thf(domain_THFTYPE_IIiooIiioI,type,(
    domain_THFTYPE_IIiooIiioI: ( $i > $o > $o ) > $i > $i > $o )).

thf(domain_THFTYPE_IIoooIiioI,type,(
    domain_THFTYPE_IIoooIiioI: ( $o > $o > $o ) > $i > $i > $o )).

thf(domain_THFTYPE_IiiioI,type,(
    domain_THFTYPE_IiiioI: $i > $i > $i > $o )).

thf(duration_THFTYPE_IiioI,type,(
    duration_THFTYPE_IiioI: $i > $i > $o )).

thf(equal_THFTYPE_i,type,(
    equal_THFTYPE_i: $i )).

thf(greaterThan_THFTYPE_i,type,(
    greaterThan_THFTYPE_i: $i )).

thf(holdsDuring_THFTYPE_IiooI,type,(
    holdsDuring_THFTYPE_IiooI: $i > $o > $o )).

thf(inList_THFTYPE_IiioI,type,(
    inList_THFTYPE_IiioI: $i > $i > $o )).

thf(instance_THFTYPE_IIIiioIiioIioI,type,(
    instance_THFTYPE_IIIiioIiioIioI: ( ( $i > $i > $o ) > $i > $i > $o ) > $i > $o )).

thf(instance_THFTYPE_IIIioIiioIioI,type,(
    instance_THFTYPE_IIIioIiioIioI: ( ( $i > $o ) > $i > $i > $o ) > $i > $o )).

thf(instance_THFTYPE_IIiiIioI,type,(
    instance_THFTYPE_IIiiIioI: ( $i > $i ) > $i > $o )).

thf(instance_THFTYPE_IIiiiIioI,type,(
    instance_THFTYPE_IIiiiIioI: ( $i > $i > $i ) > $i > $o )).

thf(instance_THFTYPE_IIiiioIioI,type,(
    instance_THFTYPE_IIiiioIioI: ( $i > $i > $i > $o ) > $i > $o )).

thf(instance_THFTYPE_IIiioIioI,type,(
    instance_THFTYPE_IIiioIioI: ( $i > $i > $o ) > $i > $o )).

thf(instance_THFTYPE_IIiooIioI,type,(
    instance_THFTYPE_IIiooIioI: ( $i > $o > $o ) > $i > $o )).

thf(instance_THFTYPE_IiioI,type,(
    instance_THFTYPE_IiioI: $i > $i > $o )).

thf(instance_THFTYPE_IoioI,type,(
    instance_THFTYPE_IoioI: $o > $i > $o )).

thf(instrument_THFTYPE_i,type,(
    instrument_THFTYPE_i: $i )).

thf(knows_THFTYPE_IiooI,type,(
    knows_THFTYPE_IiooI: $i > $o > $o )).

thf(lAdditionFn_THFTYPE_i,type,(
    lAdditionFn_THFTYPE_i: $i )).

thf(lAgent_THFTYPE_i,type,(
    lAgent_THFTYPE_i: $i )).

thf(lAsymmetricRelation_THFTYPE_i,type,(
    lAsymmetricRelation_THFTYPE_i: $i )).

thf(lAttribute_THFTYPE_i,type,(
    lAttribute_THFTYPE_i: $i )).

thf(lBeginFn_THFTYPE_IiiI,type,(
    lBeginFn_THFTYPE_IiiI: $i > $i )).

thf(lBill_THFTYPE_i,type,(
    lBill_THFTYPE_i: $i )).

thf(lBinaryFunction_THFTYPE_i,type,(
    lBinaryFunction_THFTYPE_i: $i )).

thf(lBinaryPredicate_THFTYPE_i,type,(
    lBinaryPredicate_THFTYPE_i: $i )).

thf(lCardinalityFn_THFTYPE_IiiI,type,(
    lCardinalityFn_THFTYPE_IiiI: $i > $i )).

thf(lCognitiveAgent_THFTYPE_i,type,(
    lCognitiveAgent_THFTYPE_i: $i )).

thf(lContentBearingObject_THFTYPE_i,type,(
    lContentBearingObject_THFTYPE_i: $i )).

thf(lDayDuration_THFTYPE_i,type,(
    lDayDuration_THFTYPE_i: $i )).

thf(lDay_THFTYPE_i,type,(
    lDay_THFTYPE_i: $i )).

thf(lDirectionalAttribute_THFTYPE_i,type,(
    lDirectionalAttribute_THFTYPE_i: $i )).

thf(lEndFn_THFTYPE_IiiI,type,(
    lEndFn_THFTYPE_IiiI: $i > $i )).

thf(lEntity_THFTYPE_i,type,(
    lEntity_THFTYPE_i: $i )).

thf(lFormula_THFTYPE_i,type,(
    lFormula_THFTYPE_i: $i )).

thf(lHuman_THFTYPE_i,type,(
    lHuman_THFTYPE_i: $i )).

thf(lInheritableRelation_THFTYPE_i,type,(
    lInheritableRelation_THFTYPE_i: $i )).

thf(lInteger_THFTYPE_i,type,(
    lInteger_THFTYPE_i: $i )).

thf(lIntentionalProcess_THFTYPE_i,type,(
    lIntentionalProcess_THFTYPE_i: $i )).

thf(lInternalAttribute_THFTYPE_i,type,(
    lInternalAttribute_THFTYPE_i: $i )).

thf(lIrreflexiveRelation_THFTYPE_i,type,(
    lIrreflexiveRelation_THFTYPE_i: $i )).

thf(lLinguisticExpression_THFTYPE_i,type,(
    lLinguisticExpression_THFTYPE_i: $i )).

thf(lListFn_THFTYPE_IiiI,type,(
    lListFn_THFTYPE_IiiI: $i > $i )).

thf(lListFn_THFTYPE_i,type,(
    lListFn_THFTYPE_i: $i )).

thf(lListOrderFn_THFTYPE_IiiiI,type,(
    lListOrderFn_THFTYPE_IiiiI: $i > $i > $i )).

thf(lListOrderFn_THFTYPE_i,type,(
    lListOrderFn_THFTYPE_i: $i )).

thf(lList_THFTYPE_i,type,(
    lList_THFTYPE_i: $i )).

thf(lMary_THFTYPE_i,type,(
    lMary_THFTYPE_i: $i )).

thf(lMeasureFn_THFTYPE_IiiiI,type,(
    lMeasureFn_THFTYPE_IiiiI: $i > $i > $i )).

thf(lMonthFn_THFTYPE_i,type,(
    lMonthFn_THFTYPE_i: $i )).

thf(lMonth_THFTYPE_i,type,(
    lMonth_THFTYPE_i: $i )).

thf(lMultiplicationFn_THFTYPE_i,type,(
    lMultiplicationFn_THFTYPE_i: $i )).

thf(lObject_THFTYPE_i,type,(
    lObject_THFTYPE_i: $i )).

thf(lOrganism_THFTYPE_i,type,(
    lOrganism_THFTYPE_i: $i )).

thf(lOrganization_THFTYPE_i,type,(
    lOrganization_THFTYPE_i: $i )).

thf(lPositionalAttribute_THFTYPE_i,type,(
    lPositionalAttribute_THFTYPE_i: $i )).

thf(lProcess_THFTYPE_i,type,(
    lProcess_THFTYPE_i: $i )).

thf(lProposition_THFTYPE_i,type,(
    lProposition_THFTYPE_i: $i )).

thf(lQuantity_THFTYPE_i,type,(
    lQuantity_THFTYPE_i: $i )).

thf(lRelationExtendedToQuantities_THFTYPE_i,type,(
    lRelationExtendedToQuantities_THFTYPE_i: $i )).

thf(lRelation_THFTYPE_i,type,(
    lRelation_THFTYPE_i: $i )).

thf(lRelationalAttribute_THFTYPE_i,type,(
    lRelationalAttribute_THFTYPE_i: $i )).

thf(lSelfConnectedObject_THFTYPE_i,type,(
    lSelfConnectedObject_THFTYPE_i: $i )).

thf(lSentence_THFTYPE_i,type,(
    lSentence_THFTYPE_i: $i )).

thf(lSetOrClass_THFTYPE_i,type,(
    lSetOrClass_THFTYPE_i: $i )).

thf(lSubtractionFn_THFTYPE_i,type,(
    lSubtractionFn_THFTYPE_i: $i )).

thf(lSue_THFTYPE_i,type,(
    lSue_THFTYPE_i: $i )).

thf(lTemporalCompositionFn_THFTYPE_IiiiI,type,(
    lTemporalCompositionFn_THFTYPE_IiiiI: $i > $i > $i )).

thf(lTemporalCompositionFn_THFTYPE_i,type,(
    lTemporalCompositionFn_THFTYPE_i: $i )).

thf(lTemporalRelation_THFTYPE_i,type,(
    lTemporalRelation_THFTYPE_i: $i )).

thf(lTernaryPredicate_THFTYPE_i,type,(
    lTernaryPredicate_THFTYPE_i: $i )).

thf(lText_THFTYPE_i,type,(
    lText_THFTYPE_i: $i )).

thf(lTimeInterval_THFTYPE_i,type,(
    lTimeInterval_THFTYPE_i: $i )).

thf(lTotalValuedRelation_THFTYPE_i,type,(
    lTotalValuedRelation_THFTYPE_i: $i )).

thf(lTransitiveRelation_THFTYPE_i,type,(
    lTransitiveRelation_THFTYPE_i: $i )).

thf(lTruthValue_THFTYPE_i,type,(
    lTruthValue_THFTYPE_i: $i )).

thf(lUnaryFunction_THFTYPE_i,type,(
    lUnaryFunction_THFTYPE_i: $i )).

thf(lWhenFn_THFTYPE_IiiI,type,(
    lWhenFn_THFTYPE_IiiI: $i > $i )).

thf(lWhenFn_THFTYPE_i,type,(
    lWhenFn_THFTYPE_i: $i )).

thf(lYearFn_THFTYPE_IiiI,type,(
    lYearFn_THFTYPE_IiiI: $i > $i )).

thf(lYearFn_THFTYPE_i,type,(
    lYearFn_THFTYPE_i: $i )).

thf(lYear_THFTYPE_i,type,(
    lYear_THFTYPE_i: $i )).

thf(lessThan_THFTYPE_i,type,(
    lessThan_THFTYPE_i: $i )).

thf(likes_THFTYPE_IiioI,type,(
    likes_THFTYPE_IiioI: $i > $i > $o )).

thf(located_THFTYPE_IiioI,type,(
    located_THFTYPE_IiioI: $i > $i > $o )).

thf(meetsTemporally_THFTYPE_IiioI,type,(
    meetsTemporally_THFTYPE_IiioI: $i > $i > $o )).

thf(member_THFTYPE_IiioI,type,(
    member_THFTYPE_IiioI: $i > $i > $o )).

thf(minus_THFTYPE_IiiiI,type,(
    minus_THFTYPE_IiiiI: $i > $i > $i )).

thf(modalAttribute_THFTYPE_i,type,(
    modalAttribute_THFTYPE_i: $i )).

thf(n12_THFTYPE_i,type,(
    n12_THFTYPE_i: $i )).

thf(n1_THFTYPE_i,type,(
    n1_THFTYPE_i: $i )).

thf(n2009_THFTYPE_i,type,(
    n2009_THFTYPE_i: $i )).

thf(n2_THFTYPE_i,type,(
    n2_THFTYPE_i: $i )).

thf(n3_THFTYPE_i,type,(
    n3_THFTYPE_i: $i )).

thf(orientation_THFTYPE_IiiioI,type,(
    orientation_THFTYPE_IiiioI: $i > $i > $i > $o )).

thf(part_THFTYPE_IiioI,type,(
    part_THFTYPE_IiioI: $i > $i > $o )).

thf(partition_THFTYPE_IiiioI,type,(
    partition_THFTYPE_IiiioI: $i > $i > $i > $o )).

thf(patient_THFTYPE_i,type,(
    patient_THFTYPE_i: $i )).

thf(property_THFTYPE_IiioI,type,(
    property_THFTYPE_IiioI: $i > $i > $o )).

thf(rangeSubclass_THFTYPE_IiioI,type,(
    rangeSubclass_THFTYPE_IiioI: $i > $i > $o )).

thf(range_THFTYPE_IiioI,type,(
    range_THFTYPE_IiioI: $i > $i > $o )).

thf(relatedInternalConcept_THFTYPE_IIiioIIiioIoI,type,(
    relatedInternalConcept_THFTYPE_IIiioIIiioIoI: ( $i > $i > $o ) > ( $i > $i > $o ) > $o )).

thf(relatedInternalConcept_THFTYPE_IiIiiIoI,type,(
    relatedInternalConcept_THFTYPE_IiIiiIoI: $i > ( $i > $i ) > $o )).

thf(relatedInternalConcept_THFTYPE_IiIiooIoI,type,(
    relatedInternalConcept_THFTYPE_IiIiooIoI: $i > ( $i > $o > $o ) > $o )).

thf(relatedInternalConcept_THFTYPE_IiioI,type,(
    relatedInternalConcept_THFTYPE_IiioI: $i > $i > $o )).

thf(result_THFTYPE_i,type,(
    result_THFTYPE_i: $i )).

thf(subAttribute_THFTYPE_IiioI,type,(
    subAttribute_THFTYPE_IiioI: $i > $i > $o )).

thf(subProcess_THFTYPE_IiioI,type,(
    subProcess_THFTYPE_IiioI: $i > $i > $o )).

thf(subclass_THFTYPE_IiioI,type,(
    subclass_THFTYPE_IiioI: $i > $i > $o )).

thf(subrelation_THFTYPE_IIiioIIiioIoI,type,(
    subrelation_THFTYPE_IIiioIIiioIoI: ( $i > $i > $o ) > ( $i > $i > $o ) > $o )).

thf(subrelation_THFTYPE_IIioIIioIoI,type,(
    subrelation_THFTYPE_IIioIIioIoI: ( $i > $o ) > ( $i > $o ) > $o )).

thf(subrelation_THFTYPE_IIoooIIiioIoI,type,(
    subrelation_THFTYPE_IIoooIIiioIoI: ( $o > $o > $o ) > ( $i > $i > $o ) > $o )).

thf(subrelation_THFTYPE_IiIiioIoI,type,(
    subrelation_THFTYPE_IiIiioIoI: $i > ( $i > $i > $o ) > $o )).

thf(subrelation_THFTYPE_IiioI,type,(
    subrelation_THFTYPE_IiioI: $i > $i > $o )).

thf(temporalPart_THFTYPE_IiioI,type,(
    temporalPart_THFTYPE_IiioI: $i > $i > $o )).

thf(truth_THFTYPE_IoooI,type,(
    truth_THFTYPE_IoooI: $o > $o > $o )).

%----The translated axioms
thf(ax,axiom,
    ( partition_THFTYPE_IiiioI @ lAttribute_THFTYPE_i @ lInternalAttribute_THFTYPE_i @ lRelationalAttribute_THFTYPE_i )).

thf(ax_001,axiom,(
    ! [REL2: $i,CLASS1: $i,CLASS2: $i,REL1: $i] :
      ( ( ( rangeSubclass_THFTYPE_IiioI @ REL1 @ CLASS1 )
        & ( rangeSubclass_THFTYPE_IiioI @ REL2 @ CLASS2 )
        & ( disjoint_THFTYPE_IiioI @ CLASS1 @ CLASS2 ) )
     => ( disjointRelation_THFTYPE_IiioI @ REL1 @ REL2 ) ) )).

thf(ax_002,axiom,
    ( subclass_THFTYPE_IiioI @ lInheritableRelation_THFTYPE_i @ lRelation_THFTYPE_i )).

%KIF documentation:(documentation Proposition EnglishLanguage "&%Propositions are &%Abstract entities that express a complete thought or a set of such thoughts. As an example, the formula '(instance Yojo Cat)' expresses the &%Proposition that the entity named Yojo is an element of the &%Class of Cats. Note that propositions are not restricted to the content expressed by individual sentences of a &%Language. They may encompass the content expressed by theories, books, and even whole libraries. It is important to distinguish &%Propositions from the &%ContentBearingObjects that express them. A &%Proposition is a piece of information, e.g. that the cat is on the mat, but a &%ContentBearingObject is an &%Object that represents this information. A &%Proposition is an abstraction that may have multiple representations: strings, sounds, icons, etc. For example, the &%Proposition that the cat is on the mat is represented here as a string of graphical characters displayed on a monitor and/ or printed on paper, but it can be represented by a sequence of sounds or by some non-latin alphabet or by some cryptographic form")
%KIF documentation:(documentation instance EnglishLanguage "An object is an &%instance of a &%SetOrClass if it is included in that &%SetOrClass. An individual may be an instance of many classes, some of which may be subclasses of others. Thus, there is no assumption in the meaning of &%instance about specificity or uniqueness.")
%KIF documentation:(documentation range EnglishLanguage "Gives the range of a function. In other words, (&%range ?FUNCTION ?CLASS) means that all of the values assigned by ?FUNCTION are &%instances of ?CLASS.")
%KIF documentation:(documentation Process EnglishLanguage "The class of things that happen and have temporal parts or stages. Examples include extended events like a football match or a race, actions like &%Pursuing and &%Reading, and biological processes. The formal definition is: anything that occurs in time but is not an &%Object. Note that a &%Process may have participants 'inside' it which are &%Objects, such as the players in a football match. In a 4D ontology, a &%Process is something whose spatiotemporal extent is thought of as dividing into temporal stages roughly perpendicular to the time-axis.")
thf(ax_003,axiom,(
    ! [X: $i,Y: $i,Z: $i] :
      ( ( ( subclass_THFTYPE_IiioI @ X @ Y )
        & ( instance_THFTYPE_IiioI @ Z @ X ) )
     => ( instance_THFTYPE_IiioI @ Z @ Y ) ) )).

%KIF documentation:(documentation TemporalRelation EnglishLanguage "The &%Class of temporal &%Relations. This &%Class includes notions of (temporal) topology of intervals, (temporal) schemata, and (temporal) extension.")
%KIF documentation:(documentation Agent EnglishLanguage "Something or someone that can act on its own and produce changes in the world.")
thf(ax_004,axiom,(
    ! [X: $i,Y: $i] :
      ( ( subclass_THFTYPE_IiioI @ X @ Y )
     => ( ( instance_THFTYPE_IiioI @ X @ lSetOrClass_THFTYPE_i )
        & ( instance_THFTYPE_IiioI @ Y @ lSetOrClass_THFTYPE_i ) ) ) )).

%KIF documentation:(documentation disjointRelation EnglishLanguage "This predicate relates two &%Relations. (&%disjointRelation ?REL1 ?REL2) means that the two relations have no tuples in common.")
%KIF documentation:(documentation lessThan EnglishLanguage "(&%lessThan ?NUMBER1 ?NUMBER2) is true just in case the &%Quantity ?NUMBER1 is less than the &%Quantity ?NUMBER2.")
%KIF documentation:(documentation property EnglishLanguage "This &%Predicate holds between an instance of &%Entity and an instance of &%Attribute. (&%property ?ENTITY ?ATTR) means that ?ENTITY has the &%Attribute ?ATTR.")
%KIF documentation:(documentation AsymmetricRelation EnglishLanguage "A &%BinaryRelation is asymmetric if and only if it is both an &%AntisymmetricRelation and an &%IrreflexiveRelation.")
%KIF documentation:(documentation MonthFn EnglishLanguage "A &%BinaryFunction that maps a subclass of &%Month and a subclass of &%Year to the class containing the &%Months corresponding to thos &%Years. For example (&%MonthFn &%January (&%YearFn 1912)) is the class containing the eighth &%Month, i.e. August, of the &%Year 1912. For another example, (&%MonthFn &%August &%Year) is equal to &%August, the class of all months of August. Note that this function returns a &%Class as a value. The reason for this is that the related functions, viz. DayFn, HourFn, MinuteFn, and SecondFn, are used to generate both specific &%TimeIntervals and recurrent intervals, and the only way to do this is to make the domains and ranges of these functions classes rather than individuals.")
%KIF documentation:(documentation instrument EnglishLanguage "(instrument ?EVENT ?TOOL) means that ?TOOL is used by an agent in bringing about ?EVENT and that ?TOOL is not changed by ?EVENT. For example, the key is an &%instrument in the following proposition: The key opened the door. Note that &%instrument and &%resource cannot be satisfied by the same ordered pair.")
thf(ax_005,axiom,
    ( subclass_THFTYPE_IiioI @ lFormula_THFTYPE_i @ lSentence_THFTYPE_i )).

thf(ax_006,axiom,(
    ! [THING: $i] :
      ( instance_THFTYPE_IiioI @ THING @ lEntity_THFTYPE_i ) )).

thf(ax_007,axiom,(
    ! [OBJ1: $i,OBJ2: $i] :
      ( ( located_THFTYPE_IiioI @ OBJ1 @ OBJ2 )
     => ! [SUB: $i] :
          ( ( part_THFTYPE_IiioI @ SUB @ OBJ1 )
         => ( located_THFTYPE_IiioI @ SUB @ OBJ2 ) ) ) )).

thf(ax_008,axiom,(
    ! [NUMBER: $i,MONTH: $i] :
      ( ( ( instance_THFTYPE_IiioI @ MONTH @ lMonth_THFTYPE_i )
        & ( duration_THFTYPE_IiioI @ MONTH @ ( lMeasureFn_THFTYPE_IiiiI @ NUMBER @ lDayDuration_THFTYPE_i ) ) )
     => ( ( lCardinalityFn_THFTYPE_IiiI @ ( lTemporalCompositionFn_THFTYPE_IiiiI @ MONTH @ lDay_THFTYPE_i ) )
        = NUMBER ) ) )).

%KIF documentation:(documentation disjoint EnglishLanguage "&%Classes are &%disjoint only if they share no instances, i.e. just in case the result of applying &%IntersectionFn to them is empty.")
thf(ax_009,axiom,
    ( subclass_THFTYPE_IiioI @ lDirectionalAttribute_THFTYPE_i @ lPositionalAttribute_THFTYPE_i )).

%KIF documentation:(documentation MultiplicationFn EnglishLanguage "If ?NUMBER1 and ?NUMBER2 are &%Numbers, then (&%MultiplicationFn ?NUMBER1 ?NUMBER2) is the arithmetical product of these numbers.")
%KIF documentation:(documentation domain EnglishLanguage "Provides a computationally and heuristically convenient mechanism for declaring the argument types of a given relation. The formula (&%domain ?REL ?INT ?CLASS) means that the ?INT'th element of each tuple in the relation ?REL must be an instance of ?CLASS. Specifying argument types is very helpful in maintaining ontologies. Representation systems can use these specifications to classify terms and check integrity constraints. If the restriction on the argument type of a &%Relation is not captured by a &%SetOrClass already defined in the ontology, one can specify a &%SetOrClass compositionally with the functions &%UnionFn, &%IntersectionFn, etc.")
thf(ax_010,axiom,(
    ! [AGENT: $i] :
      ( ( instance_THFTYPE_IiioI @ AGENT @ lAgent_THFTYPE_i )
    <=> ? [PROC: $i] :
          ( agent_THFTYPE_IiioI @ PROC @ AGENT ) ) )).

thf(ax_011,axiom,(
    ! [ATTR2: $i,OBJ1: $i,ROW: $i,OBJ2: $i,ATTR1: $i] :
      ( ( ( orientation_THFTYPE_IiiioI @ OBJ1 @ OBJ2 @ ATTR1 )
        & ( contraryAttribute_THFTYPE_IioI @ ROW )
        & ( inList_THFTYPE_IiioI @ ATTR1 @ ( lListFn_THFTYPE_IiiI @ ROW ) )
        & ( inList_THFTYPE_IiioI @ ATTR2 @ ( lListFn_THFTYPE_IiiI @ ROW ) )
        & ( (~) @ ( ATTR1 = ATTR2 ) ) )
     => ( (~) @ ( orientation_THFTYPE_IiiioI @ OBJ1 @ OBJ2 @ ATTR2 ) ) ) )).

%KIF documentation:(documentation rangeSubclass EnglishLanguage "(&%rangeSubclass ?FUNCTION ?CLASS) means that all of the values assigned by ?FUNCTION are &%subclasses of ?CLASS.")
%KIF documentation:(documentation TimeInterval EnglishLanguage "An interval of time. Note that a &%TimeInterval has both an extent and a location on the universal timeline. Note too that a &%TimeInterval has no gaps, i.e. this class contains only convex time intervals.")
%KIF documentation:(documentation TernaryPredicate EnglishLanguage "The &%Class of &%Predicates that require exactly three arguments.")
thf(ax_012,axiom,
    ( subclass_THFTYPE_IiioI @ lTruthValue_THFTYPE_i @ lRelationalAttribute_THFTYPE_i )).

thf(ax_013,axiom,(
    ! [CLASS: $i,ATTR2: $i,ATTR1: $i] :
      ( ( ( subAttribute_THFTYPE_IiioI @ ATTR1 @ ATTR2 )
        & ( instance_THFTYPE_IiioI @ ATTR2 @ CLASS ) )
     => ( instance_THFTYPE_IiioI @ ATTR1 @ CLASS ) ) )).

thf(ax_014,axiom,
    ( range_THFTYPE_IiioI @ lListFn_THFTYPE_i @ lList_THFTYPE_i )).

thf(ax_015,axiom,
    ( subclass_THFTYPE_IiioI @ lAsymmetricRelation_THFTYPE_i @ lIrreflexiveRelation_THFTYPE_i )).

thf(ax_016,axiom,
    ( subclass_THFTYPE_IiioI @ lTotalValuedRelation_THFTYPE_i @ lInheritableRelation_THFTYPE_i )).

%KIF documentation:(documentation Relation EnglishLanguage "The &%Class of relations. There are three kinds of &%Relation: &%Predicate, &%Function, and &%List. &%Predicates and &%Functions both denote sets of ordered n-tuples. The difference between these two &%Classes is that &%Predicates cover formula-forming operators, while &%Functions cover term-forming operators. A &%List, on the other hand, is a particular ordered n-tuple.")
thf(ax_017,axiom,(
    ! [SENT: $i] :
      ( ( instance_THFTYPE_IiioI @ SENT @ lSentence_THFTYPE_i )
     => ? [PROP: $o] :
          ( ( instance_THFTYPE_IoioI @ PROP @ lProposition_THFTYPE_i )
          & ( containsInformation_THFTYPE_IiooI @ SENT @ PROP ) ) ) )).

thf(ax_018,axiom,(
    ! [NUMBER: $i,CLASS1: $i,REL: $i,CLASS2: $i] :
      ( ( ( domainSubclass_THFTYPE_IiiioI @ REL @ NUMBER @ CLASS1 )
        & ( domainSubclass_THFTYPE_IiiioI @ REL @ NUMBER @ CLASS2 ) )
     => ( ( subclass_THFTYPE_IiioI @ CLASS1 @ CLASS2 )
        | ( subclass_THFTYPE_IiioI @ CLASS2 @ CLASS1 ) ) ) )).

thf(ax_019,axiom,(
    ! [DAY: $i] :
      ( ( instance_THFTYPE_IiioI @ DAY @ lDay_THFTYPE_i )
     => ( duration_THFTYPE_IiioI @ DAY @ ( lMeasureFn_THFTYPE_IiiiI @ n1_THFTYPE_i @ lDayDuration_THFTYPE_i ) ) ) )).

%KIF documentation:(documentation modalAttribute EnglishLanguage "A &%BinaryRelation that is used to state the normative force of a &%Proposition. (&%modalAttribute ?FORMULA ?PROP) means that the &%Proposition expressed by ?FORMULA has the &%NormativeAttribute ?PROP. For example, (&%modalAttribute (&%exists (?ACT ?OBJ) (&%and (&%instance ?ACT &%Giving) (&%agent ?ACT John) (&%patient ?ACT ?OBJ) (&%destination ?ACT Tom))) &%Obligation) means that John is obligated to give Tom something.")
thf(ax_020,axiom,(
    ! [FORMULA: $o,AGENT: $i] :
      ( ( knows_THFTYPE_IiooI @ AGENT @ FORMULA )
     => ( truth_THFTYPE_IoooI @ FORMULA @ $true ) ) )).

thf(ax_021,axiom,(
    ! [REL2: $i,NUMBER: $i,CLASS1: $i,CLASS2: $i,REL1: $i] :
      ( ( ( domainSubclass_THFTYPE_IiiioI @ REL1 @ NUMBER @ CLASS1 )
        & ( domainSubclass_THFTYPE_IiiioI @ REL2 @ NUMBER @ CLASS2 )
        & ( disjoint_THFTYPE_IiioI @ CLASS1 @ CLASS2 ) )
     => ( disjointRelation_THFTYPE_IiioI @ REL1 @ REL2 ) ) )).

%KIF documentation:(documentation documentation EnglishLanguage "A relation between objects in the domain of discourse and strings of natural language text stated in a particular &%HumanLanguage. The domain of &%documentation is not constants (names), but the objects themselves. This means that one does not quote the names when associating them with their documentation.")
thf(ax_022,axiom,
    ( subclass_THFTYPE_IiioI @ lTemporalRelation_THFTYPE_i @ lRelation_THFTYPE_i )).

%KIF documentation:(documentation Organization EnglishLanguage "An &%Organization is a corporate or similar institution. The &%members of an &%Organization typically have a common purpose or function. Note that this class also covers divisions, departments, etc. of organizations. For example, both the Shell Corporation and the accounting department at Shell would both be instances of &%Organization. Note too that the existence of an &%Organization is dependent on the existence of at least one &%member (since &%Organization is a subclass of &%Collection). Accordingly, in cases of purely legal organizations, a fictitious &%member should be assumed.")
thf(ax_023,axiom,
    ( subclass_THFTYPE_IiioI @ lYear_THFTYPE_i @ lTimeInterval_THFTYPE_i )).

thf(ax_024,axiom,
    ( subclass_THFTYPE_IiioI @ lIntentionalProcess_THFTYPE_i @ lProcess_THFTYPE_i )).

thf(ax_025,axiom,(
    ! [NUMBER: $i,CLASS1: $i,REL: $i,CLASS2: $i] :
      ( ( ( domain_THFTYPE_IiiioI @ REL @ NUMBER @ CLASS1 )
        & ( domain_THFTYPE_IiiioI @ REL @ NUMBER @ CLASS2 ) )
     => ( ( subclass_THFTYPE_IiioI @ CLASS1 @ CLASS2 )
        | ( subclass_THFTYPE_IiioI @ CLASS2 @ CLASS1 ) ) ) )).

%KIF documentation:(documentation Sentence EnglishLanguage "A syntactically well-formed formula of a &%Language. It includes, at minimum, a predicate and a subject (which may be explicit or implicit), and it expresses a &%Proposition.")
thf(ax_026,axiom,
    ( subclass_THFTYPE_IiioI @ lText_THFTYPE_i @ lContentBearingObject_THFTYPE_i )).

thf(ax_027,axiom,(
    ! [REL: $i > $i > $o] :
      ( ( instance_THFTYPE_IIiioIioI @ REL @ lTransitiveRelation_THFTYPE_i )
    <=> ! [INST1: $i,INST2: $i,INST3: $i] :
          ( ( ( REL @ INST1 @ INST2 )
            & ( REL @ INST2 @ INST3 ) )
         => ( REL @ INST1 @ INST3 ) ) ) )).

thf(ax_028,axiom,(
    ! [THING2: $i,THING1: $i] :
      ( ( THING1 = THING2 )
     => ! [ATTR: $i] :
          ( ( property_THFTYPE_IiioI @ THING1 @ ATTR )
        <=> ( property_THFTYPE_IiioI @ THING2 @ ATTR ) ) ) )).

%KIF documentation:(documentation TemporalCompositionFn EnglishLanguage "The basic &%Function for expressing the composition of larger &%TimeIntervals out of smaller &%TimeIntervals. For example, if &%ThisSeptember is an &%instance of &%September, (&%TemporalCompositionFn &%ThisSeptember &%Day) denotes the &%Class of consecutive days that make up &%ThisSeptember. Note that one can obtain the number of instances of this &%Class by using the function &%CardinalityFn.")
thf(ax_029,axiom,(
    ! [ATTR2: $i,OBJ1: $i,OBJ2: $i,ATTR1: $i] :
      ( ( ( orientation_THFTYPE_IiiioI @ OBJ1 @ OBJ2 @ ATTR1 )
        & ( instance_THFTYPE_IiioI @ ATTR1 @ lDirectionalAttribute_THFTYPE_i )
        & ( instance_THFTYPE_IiioI @ ATTR2 @ lDirectionalAttribute_THFTYPE_i )
        & ( (~) @ ( ATTR1 = ATTR2 ) ) )
     => ( (~) @ ( orientation_THFTYPE_IiiioI @ OBJ1 @ OBJ2 @ ATTR2 ) ) ) )).

thf(ax_030,axiom,
    ( rangeSubclass_THFTYPE_IiioI @ lTemporalCompositionFn_THFTYPE_i @ lTimeInterval_THFTYPE_i )).

%KIF documentation:(documentation RelationExtendedToQuantities EnglishLanguage "A &%RelationExtendedToQuantities is a &%Relation that, when it is true on a sequence of arguments that are &%RealNumbers, it is also true on a sequence of instances of &%ConstantQuantity with those magnitudes in some unit of measure. For example, the &%lessThan relation is extended to quantities. This means that for all pairs of quantities ?QUANTITY1 and ?QUANTITY2, (&%lessThan ?QUANTITY1 ?QUANTITY2) if and only if, for some ?NUMBER1, ?NUMBER2, and ?UNIT, ?QUANTITY1 = (&%MeasureFn ?NUMBER1 ?UNIT), ?QUANTITY2 = (&%MeasureFn ?NUMBER2 ?UNIT), and (&%lessThan ?NUMBER1 ?NUMBER2), for all units ?UNIT on which ?QUANTITY1 and ?QUANTITY2 can be measured. Note that, when a &%RelationExtendedToQuantities is extended from &%RealNumbers to instances of &%ConstantQuantity, the &%ConstantQuantity must be measured along the same physical dimension.")
%KIF documentation:(documentation member EnglishLanguage "A specialized common sense notion of part for uniform parts of &%Collections. For example, each sheep in a flock of sheep would have the relationship of member to the flock.")
%KIF documentation:(documentation equal EnglishLanguage "(equal ?ENTITY1 ?ENTITY2) is true just in case ?ENTITY1 is identical with ?ENTITY2.")
%KIF documentation:(documentation CardinalityFn EnglishLanguage "(CardinalityFn ?CLASS) returns the number of instances in the &%SetOrClass ?CLASS or the number of members in the ?CLASS &%Collection.")
thf(ax_031,axiom,
    ( subclass_THFTYPE_IiioI @ lList_THFTYPE_i @ lRelation_THFTYPE_i )).

%KIF documentation:(documentation ListFn EnglishLanguage "A &%Function that takes any number of arguments and returns the &%List containing those arguments in exactly the same order.")
thf(ax_032,axiom,
    ( subclass_THFTYPE_IiioI @ lHuman_THFTYPE_i @ lCognitiveAgent_THFTYPE_i )).

thf(ax_033,axiom,(
    ! [REL2: $i,CLASS1: $i,CLASS2: $i,REL1: $i] :
      ( ( ( range_THFTYPE_IiioI @ REL1 @ CLASS1 )
        & ( range_THFTYPE_IiioI @ REL2 @ CLASS2 )
        & ( disjoint_THFTYPE_IiioI @ CLASS1 @ CLASS2 ) )
     => ( disjointRelation_THFTYPE_IiioI @ REL1 @ REL2 ) ) )).

thf(ax_034,axiom,
    ( subclass_THFTYPE_IiioI @ lRelationExtendedToQuantities_THFTYPE_i @ lRelation_THFTYPE_i )).

thf(ax_035,axiom,
    ( subclass_THFTYPE_IiioI @ lMonth_THFTYPE_i @ lTimeInterval_THFTYPE_i )).

thf(ax_036,axiom,
    ( subclass_THFTYPE_IiioI @ lText_THFTYPE_i @ lLinguisticExpression_THFTYPE_i )).

thf(ax_037,axiom,(
    ! [TIME: $i,SITUATION: $o] :
      ( ( holdsDuring_THFTYPE_IiooI @ TIME @ ( (~) @ SITUATION ) )
     => ( (~) @ ( holdsDuring_THFTYPE_IiooI @ TIME @ SITUATION ) ) ) )).

thf(ax_038,axiom,(
    ! [LIST2: $i,LIST1: $i] :
      ( ( ( instance_THFTYPE_IiioI @ LIST1 @ lList_THFTYPE_i )
        & ( instance_THFTYPE_IiioI @ LIST2 @ lList_THFTYPE_i )
        & ! [NUMBER: $i] :
            ( ( lListOrderFn_THFTYPE_IiiiI @ LIST1 @ NUMBER )
            = ( lListOrderFn_THFTYPE_IiiiI @ LIST2 @ NUMBER ) ) )
     => ( LIST1 = LIST2 ) ) )).

%KIF documentation:(documentation holdsDuring EnglishLanguage "(&%holdsDuring ?TIME ?FORMULA) means that the proposition denoted by ?FORMULA is true in the time frame ?TIME. Note that this implies that ?FORMULA is true at every &%TimePoint which is a &%temporalPart of ?TIME.")
thf(ax_039,axiom,
    ( subclass_THFTYPE_IiioI @ lPositionalAttribute_THFTYPE_i @ lRelationalAttribute_THFTYPE_i )).

thf(ax_040,axiom,
    ( likes_THFTYPE_IiioI @ lMary_THFTYPE_i @ lBill_THFTYPE_i )).

%KIF documentation:(documentation Integer EnglishLanguage "A negative or nonnegative whole number.")
%KIF documentation:(documentation attribute EnglishLanguage "(&%attribute ?OBJECT ?PROPERTY) means that ?PROPERTY is a &%Attribute of ?OBJECT. For example, (&%attribute &%MyLittleRedWagon &%Red).")
%KIF documentation:(documentation RelationalAttribute EnglishLanguage "Any &%Attribute that an &%Entity has by virtue of a relationship that it bears to another &%Entity or set of &%Entities, e.g. &%SocialRoles and &%PositionalAttributes.")
thf(ax_041,axiom,
    ( range_THFTYPE_IiioI @ lWhenFn_THFTYPE_i @ lTimeInterval_THFTYPE_i )).

%KIF documentation:(documentation greaterThan EnglishLanguage "(&%greaterThan ?NUMBER1 ?NUMBER2) is true just in case the &%Quantity ?NUMBER1 is greater than the &%Quantity ?NUMBER2.")
%KIF documentation:(documentation Organism EnglishLanguage "Generally, a living individual, including all &%Plants and &%Animals.")
thf(ax_042,axiom,(
    ! [INTERVAL1: $i,INTERVAL2: $i] :
      ( ( meetsTemporally_THFTYPE_IiioI @ INTERVAL1 @ INTERVAL2 )
    <=> ( ( lEndFn_THFTYPE_IiiI @ INTERVAL1 )
        = ( lBeginFn_THFTYPE_IiiI @ INTERVAL2 ) ) ) )).

%KIF documentation:(documentation inList EnglishLanguage "The analog of &%element and &%instance for &%Lists. (&%inList ?OBJ ?LIST) means that ?OBJ is in the &%List ?LIST. For example, (&%inList &%Tuesday (&%ListFn &%Monday &%Tuesday &%Wednesday)) would be true.")
thf(ax_043,axiom,(
    ! [SITUATION: $o,TIME2: $i,TIME1: $i] :
      ( ( ( holdsDuring_THFTYPE_IiooI @ TIME1 @ SITUATION )
        & ( temporalPart_THFTYPE_IiioI @ TIME2 @ TIME1 ) )
     => ( holdsDuring_THFTYPE_IiooI @ TIME2 @ SITUATION ) ) )).

%KIF documentation:(documentation Formula EnglishLanguage "A syntactically well-formed formula in the SUO-KIF knowledge representation language.")
%KIF documentation:(documentation TruthValue EnglishLanguage "The &%Class of truth values, e.g. &%True and &%False. These are &%Attributes of &%Sentences and &%Propositions.")
%KIF documentation:(documentation False EnglishLanguage "The &%TruthValue of being false.")
thf(ax_044,axiom,
    ( range_THFTYPE_IiioI @ lMultiplicationFn_THFTYPE_i @ lQuantity_THFTYPE_i )).

thf(ax_045,axiom,
    ( contraryAttribute_THFTYPE_IoooI @ $false @ $true )).

thf(ax_046,axiom,(
    ? [THING: $i] :
      ( instance_THFTYPE_IiioI @ THING @ lEntity_THFTYPE_i ) )).

thf(ax_047,axiom,
    ( range_THFTYPE_IiioI @ lListOrderFn_THFTYPE_i @ lEntity_THFTYPE_i )).

thf(ax_048,axiom,(
    ! [REL: $i > $i > $o] :
      ( ( instance_THFTYPE_IIiioIioI @ REL @ lIrreflexiveRelation_THFTYPE_i )
    <=> ! [INST: $i] :
          ( (~) @ ( REL @ INST @ INST ) ) ) )).

thf(ax_049,axiom,
    ( subclass_THFTYPE_IiioI @ lBinaryFunction_THFTYPE_i @ lInheritableRelation_THFTYPE_i )).

thf(ax_050,axiom,(
    ! [NUMBER: $i,PRED1: $i,CLASS1: $i,PRED2: $i] :
      ( ( ( subrelation_THFTYPE_IiioI @ PRED1 @ PRED2 )
        & ( domain_THFTYPE_IiiioI @ PRED2 @ NUMBER @ CLASS1 ) )
     => ( domain_THFTYPE_IiiioI @ PRED1 @ NUMBER @ CLASS1 ) ) )).

%KIF documentation:(documentation domainSubclass EnglishLanguage "&%Predicate used to specify argument type restrictions of &%Predicates. The formula (&%domainSubclass ?REL ?INT ?CLASS) means that the ?INT'th element of each tuple in the relation ?REL must be a subclass of ?CLASS.")
%KIF documentation:(documentation located EnglishLanguage "(&%located ?PHYS ?OBJ) means that ?PHYS is &%partlyLocated at ?OBJ, and there is no &%part or &%subProcess of ?PHYS that is not &%located at ?OBJ.")
thf(ax_051,axiom,
    ( subclass_THFTYPE_IiioI @ lTotalValuedRelation_THFTYPE_i @ lRelation_THFTYPE_i )).

%KIF documentation:(documentation DirectionalAttribute EnglishLanguage "The subclass of &%PositionalAttributes that concern compass directions.")
thf(ax_052,axiom,(
    ! [NUMBER: $i,CLASS: $i,REL: $i > $o,ROW: $i] :
      ( ( ( domainSubclass_THFTYPE_IIioIiioI @ REL @ NUMBER @ CLASS )
        & ( REL @ ROW ) )
     => ( subclass_THFTYPE_IiioI @ ( lListOrderFn_THFTYPE_IiiiI @ ( lListFn_THFTYPE_IiiI @ ROW ) @ NUMBER ) @ CLASS ) ) )).

%KIF documentation:(documentation List EnglishLanguage "Every &%List is a particular ordered n-tuple of items. Generally speaking, &%Lists are created by means of the &%ListFn &%Function, which takes any number of items as arguments and returns a &%List with the items in the same order. Anything, including other &%Lists, may be an item in a &%List. Note too that &%Lists are extensional - two lists that have the same items in the same order are identical. Note too that a &%List may contain no items. In that case, the &%List is the &%NullList.")
thf(ax_053,axiom,
    ( subclass_THFTYPE_IiioI @ lTernaryPredicate_THFTYPE_i @ lInheritableRelation_THFTYPE_i )).

thf(ax_054,axiom,
    ( subclass_THFTYPE_IiioI @ lRelationExtendedToQuantities_THFTYPE_i @ lInheritableRelation_THFTYPE_i )).

thf(ax_055,axiom,(
    ! [YEAR: $i] :
      ( ( instance_THFTYPE_IiioI @ YEAR @ lYear_THFTYPE_i )
     => ( ( lCardinalityFn_THFTYPE_IiiI @ ( lTemporalCompositionFn_THFTYPE_IiiiI @ YEAR @ lMonth_THFTYPE_i ) )
        = n12_THFTYPE_i ) ) )).

%KIF documentation:(documentation SubtractionFn EnglishLanguage "If ?NUMBER1 and ?NUMBER2 are &%Numbers, then (&%SubtractionFn ?NUMBER1 ?NUMBER2) is the arithmetical difference between ?NUMBER1 and ?NUMBER2, i.e. ?NUMBER1 minus ?NUMBER2. An exception occurs when ?NUMBER1 is equal to 0, in which case (&%SubtractionFn ?NUMBER1 ?NUMBER2) is the negation of ?NUMBER2.")
%KIF documentation:(documentation IrreflexiveRelation EnglishLanguage "&%Relation ?REL is irreflexive iff (?REL ?INST ?INST) holds for no value of ?INST.")
%KIF documentation:(documentation Day EnglishLanguage "The &%Class of all calendar &%Days.")
%KIF documentation:(documentation contraryAttribute EnglishLanguage "A &%contraryAttribute is a set of &%Attributes such that something can not simultaneously have more than one of these &%Attributes. For example, (&%contraryAttribute &%Pliable &%Rigid) means that nothing can be both &%Pliable and &%Rigid.")
thf(ax_056,axiom,
    ( subclass_THFTYPE_IiioI @ lSelfConnectedObject_THFTYPE_i @ lObject_THFTYPE_i )).

%KIF documentation:(documentation TotalValuedRelation EnglishLanguage "A &%Relation is a &%TotalValuedRelation just in case there exists an assignment for the last argument position of the &%Relation given any assignment of values to every argument position except the last one. Note that declaring a &%Relation to be both a &%TotalValuedRelation and a &%SingleValuedRelation means that it is a total function.")
thf(ax_057,axiom,(
    ! [CLASS1: $i,CLASS2: $i] :
      ( ( CLASS1 = CLASS2 )
     => ! [THING: $i] :
          ( ( instance_THFTYPE_IiioI @ THING @ CLASS1 )
        <=> ( instance_THFTYPE_IiioI @ THING @ CLASS2 ) ) ) )).

%KIF documentation:(documentation duration EnglishLanguage "(&%duration ?POS ?TIME) means that the duration of the &%TimePosition ?POS is ?TIME. Note that this &%Predicate can be used in conjunction with the &%Function &%WhenFn to specify the duration of any instance of &%Physical.")
%KIF documentation:(documentation PositionalAttribute EnglishLanguage "&%Attributes characterizing the orientation of an &%Object, e.g. &%Vertical versus &%Horizontal, &%Left versus &%Right etc.")
thf(ax_058,axiom,(
    ! [REL2: $i,CLASS1: $i,REL1: $i] :
      ( ( ( subrelation_THFTYPE_IiioI @ REL1 @ REL2 )
        & ( rangeSubclass_THFTYPE_IiioI @ REL2 @ CLASS1 ) )
     => ( rangeSubclass_THFTYPE_IiioI @ REL1 @ CLASS1 ) ) )).

thf(ax_059,axiom,(
    ! [VALUE: $i,ITEM: $i] :
      ( ( ( property_THFTYPE_IiioI @ ITEM @ VALUE )
        & ( instance_THFTYPE_IiioI @ VALUE @ lTruthValue_THFTYPE_i ) )
     => ( ( instance_THFTYPE_IiioI @ ITEM @ lSentence_THFTYPE_i )
        | ( instance_THFTYPE_IiioI @ ITEM @ lProposition_THFTYPE_i ) ) ) )).

%KIF documentation:(documentation Quantity EnglishLanguage "Any specification of how many or how much of something there is. Accordingly, there are two subclasses of &%Quantity: &%Number (how many) and &%PhysicalQuantity (how much).")
thf(ax_060,axiom,(
    ! [NUMBER: $i,CLASS: $i,REL: $i > $o,ROW: $i] :
      ( ( ( domain_THFTYPE_IIioIiioI @ REL @ NUMBER @ CLASS )
        & ( REL @ ROW ) )
     => ( instance_THFTYPE_IiioI @ ( lListOrderFn_THFTYPE_IiiiI @ ( lListFn_THFTYPE_IiiI @ ROW ) @ NUMBER ) @ CLASS ) ) )).

thf(ax_061,axiom,(
    ! [YEAR2: $i,YEAR1: $i] :
      ( ( ( instance_THFTYPE_IiioI @ YEAR1 @ lYear_THFTYPE_i )
        & ( instance_THFTYPE_IiioI @ YEAR2 @ lYear_THFTYPE_i )
        & ( ( minus_THFTYPE_IiiiI @ YEAR2 @ YEAR1 )
          = n1_THFTYPE_i ) )
     => ( meetsTemporally_THFTYPE_IiioI @ YEAR1 @ YEAR2 ) ) )).

thf(ax_062,axiom,(
    ! [REL2: $i > $o,ROW: $i,REL1: $i > $o] :
      ( ( ( subrelation_THFTYPE_IIioIIioIoI @ REL1 @ REL2 )
        & ( REL1 @ ROW ) )
     => ( REL2 @ ROW ) ) )).

%KIF documentation:(documentation LinguisticExpression EnglishLanguage "This is the subclass of &%ContentBearingPhysical which are language-related. Note that this &%Class encompasses both &%Language and the the elements of &%Languages, e.g. &%Words.")
%KIF documentation:(documentation YearFn EnglishLanguage "A &%UnaryFunction that maps a number to the corresponding calendar &%Year. For example, (&%YearFn 1912) returns the &%Class containing just one instance, the year of 1912. As might be expected, positive integers return years in the Common Era, while negative integers return years in B.C.E. Note that this function returns a &%Class as a value. The reason for this is that the related functions, viz. &%MonthFn, &%DayFn, &%HourFn, &%MinuteFn, and &%SecondFn, are used to generate both specific &%TimeIntervals and recurrent intervals, and the only way to do this is to make the domains and ranges of these functions classes rather than individuals.")
%KIF documentation:(documentation subProcess EnglishLanguage "(&%subProcess ?SUBPROC ?PROC) means that ?SUBPROC is a subprocess of ?PROC. A subprocess is here understood as a temporally distinguished part (proper or not) of a &%Process.")
thf(ax_063,axiom,
    ( subclass_THFTYPE_IiioI @ lRelationalAttribute_THFTYPE_i @ lAttribute_THFTYPE_i )).

thf(ax_064,axiom,(
    ! [FORMULA: $o,AGENT: $i] :
      ( ( knows_THFTYPE_IiooI @ AGENT @ FORMULA )
     => ( believes_THFTYPE_IiooI @ AGENT @ FORMULA ) ) )).

thf(ax_065,axiom,(
    ! [THING2: $i,THING1: $i] :
      ( ( THING1 = THING2 )
     => ! [CLASS: $i] :
          ( ( instance_THFTYPE_IiioI @ THING1 @ CLASS )
        <=> ( instance_THFTYPE_IiioI @ THING2 @ CLASS ) ) ) )).

thf(ax_066,axiom,(
    ! [ORG: $i,AGENT: $i] :
      ( ( ( instance_THFTYPE_IiioI @ ORG @ lOrganization_THFTYPE_i )
        & ( member_THFTYPE_IiioI @ AGENT @ ORG ) )
     => ( instance_THFTYPE_IiioI @ AGENT @ lAgent_THFTYPE_i ) ) )).

thf(ax_067,axiom,(
    ! [CLASS1: $i,REL: $i,CLASS2: $i] :
      ( ( ( range_THFTYPE_IiioI @ REL @ CLASS1 )
        & ( range_THFTYPE_IiioI @ REL @ CLASS2 ) )
     => ( ( subclass_THFTYPE_IiioI @ CLASS1 @ CLASS2 )
        | ( subclass_THFTYPE_IiioI @ CLASS2 @ CLASS1 ) ) ) )).

thf(ax_068,axiom,(
    ! [X: $i] :
      ( holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i ) @ ( (~) @ ( likes_THFTYPE_IiioI @ lSue_THFTYPE_i @ X ) ) ) )).

thf(ax_069,axiom,
    ( subclass_THFTYPE_IiioI @ lOrganism_THFTYPE_i @ lAgent_THFTYPE_i )).

thf(ax_070,axiom,(
    ! [CLASS1: $i,CLASS2: $i] :
      ( ( disjoint_THFTYPE_IiioI @ CLASS1 @ CLASS2 )
    <=> ! [INST: $i] :
          ( (~)
          @ ( ( instance_THFTYPE_IiioI @ INST @ CLASS1 )
            & ( instance_THFTYPE_IiioI @ INST @ CLASS2 ) ) ) ) )).

%KIF documentation:(documentation orientation EnglishLanguage "A general &%Predicate for indicating how two &%Objects are oriented with respect to one another. For example, (orientation ?OBJ1 ?OBJ2 North) means that ?OBJ1 is north of ?OBJ2, and (orientation ?OBJ1 ?OBJ2 Vertical) means that ?OBJ1 is positioned vertically with respect to ?OBJ2.")
%KIF documentation:(documentation UnaryFunction EnglishLanguage "The &%Class of &%Functions that require a single argument.")
thf(ax_071,axiom,(
    ! [SUBPROC: $i,PROC: $i] :
      ( ( subProcess_THFTYPE_IiioI @ SUBPROC @ PROC )
     => ( temporalPart_THFTYPE_IiioI @ ( lWhenFn_THFTYPE_IiiI @ SUBPROC ) @ ( lWhenFn_THFTYPE_IiiI @ PROC ) ) ) )).

%KIF documentation:(documentation subAttribute EnglishLanguage "Means that the second argument can be ascribed to everything which has the first argument ascribed to it.")
%KIF documentation:(documentation AdditionFn EnglishLanguage "If ?NUMBER1 and ?NUMBER2 are &%Numbers, then (&%AdditionFn ?NUMBER1 ?NUMBER2) is the arithmetical sum of these numbers.")
%KIF documentation:(documentation relatedInternalConcept EnglishLanguage "Means that the two arguments are related concepts within the SUMO, i.e. there is a significant similarity of meaning between them. To indicate a meaning relation between a SUMO concept and a concept from another source, use the Predicate &%relatedExternalConcept.")
thf(ax_072,axiom,
    ( rangeSubclass_THFTYPE_IiioI @ lMonthFn_THFTYPE_i @ lMonth_THFTYPE_i )).

thf(ax_073,axiom,(
    ! [INTERVAL1: $i,INTERVAL2: $i] :
      ( ( ( ( lBeginFn_THFTYPE_IiiI @ INTERVAL1 )
          = ( lBeginFn_THFTYPE_IiiI @ INTERVAL2 ) )
        & ( ( lEndFn_THFTYPE_IiiI @ INTERVAL1 )
          = ( lEndFn_THFTYPE_IiiI @ INTERVAL2 ) ) )
     => ( INTERVAL1 = INTERVAL2 ) ) )).

%KIF documentation:(documentation BinaryPredicate EnglishLanguage "A &%Predicate relating two items - its valence is two.")
thf(ax_074,axiom,
    ( subclass_THFTYPE_IiioI @ lOrganization_THFTYPE_i @ lCognitiveAgent_THFTYPE_i )).

%KIF documentation:(documentation SetOrClass EnglishLanguage "The &%SetOrClass of &%Sets and &%Classes, i.e. any instance of &%Abstract that has &%elements or &%instances.")
thf(ax_075,axiom,(
    ! [REL2: $i,CLASS1: $i,REL1: $i] :
      ( ( ( subrelation_THFTYPE_IiioI @ REL1 @ REL2 )
        & ( range_THFTYPE_IiioI @ REL2 @ CLASS1 ) )
     => ( range_THFTYPE_IiioI @ REL1 @ CLASS1 ) ) )).

%KIF documentation:(documentation MeasureFn EnglishLanguage "This &%BinaryFunction maps a &%RealNumber and a &%UnitOfMeasure to that &%Number of units. It is used to express `measured' instances of &%PhysicalQuantity. Example: the concept of three meters is represented as (&%MeasureFn 3 &%Meter).")
%KIF documentation:(documentation subclass EnglishLanguage "(&%subclass ?CLASS1 ?CLASS2) means that ?CLASS1 is a subclass of ?CLASS2, i.e. every instance of ?CLASS1 is also an instance of ?CLASS2. A class may have multiple superclasses and subclasses.")
%KIF documentation:(documentation part EnglishLanguage "The basic mereological relation. All other mereological relations are defined in terms of this one. (&%part ?PART ?WHOLE) simply means that the &%Object ?PART is part of the &%Object ?WHOLE. Note that, since &%part is a &%ReflexiveRelation, every &%Object is a part of itself.")
%KIF documentation:(documentation BinaryFunction EnglishLanguage "The &%Class of &%Functions that require two arguments.")
%KIF documentation:(documentation Entity EnglishLanguage "The universal class of individuals. This is the root node of the ontology.")
thf(ax_076,axiom,(
    ! [OBJ: $i,NUMBER2: $i,ROW: $i,NUMBER1: $i] :
      ( ( contraryAttribute_THFTYPE_IioI @ ROW )
     => ! [ATTR1: $i,ATTR2: $i] :
          ( ( ( ATTR1
              = ( lListOrderFn_THFTYPE_IiiiI @ ( lListFn_THFTYPE_IiiI @ ROW ) @ NUMBER1 ) )
            & ( ATTR2
              = ( lListOrderFn_THFTYPE_IiiiI @ ( lListFn_THFTYPE_IiiI @ ROW ) @ NUMBER2 ) )
            & ( (~) @ ( NUMBER1 = NUMBER2 ) ) )
         => ( ( property_THFTYPE_IiioI @ OBJ @ ATTR1 )
           => ( (~) @ ( property_THFTYPE_IiioI @ OBJ @ ATTR2 ) ) ) ) ) )).

%KIF documentation:(documentation WhenFn EnglishLanguage "A &%UnaryFunction that maps an &%Object or &%Process to the exact &%TimeInterval during which it exists. Note that, for every &%TimePoint ?TIME outside of the &%TimeInterval (WhenFn ?THING), (time ?THING ?TIME) does not hold.")
%KIF documentation:(documentation CognitiveAgent EnglishLanguage "A &%SentientAgent with responsibilities and the ability to reason, deliberate, make plans, etc. This is essentially the legal/ ethical notion of a person. Note that, although &%Human is a subclass of &%CognitiveAgent, there may be instances of &%CognitiveAgent which are not also instances of &%Human. For example, chimpanzees, gorillas, dolphins, whales, and some extraterrestrials (if they exist) may be &%CognitiveAgents.")
thf(ax_077,axiom,
    ( subclass_THFTYPE_IiioI @ lTemporalRelation_THFTYPE_i @ lInheritableRelation_THFTYPE_i )).

%KIF documentation:(documentation truth EnglishLanguage "The &%BinaryPredicate that relates a &%Sentence to its &%TruthValue.")
%KIF documentation:(documentation ListOrderFn EnglishLanguage "(&%ListOrderFn ?LIST ?NUMBER) denotes the item that is in the ?NUMBER position in the &%List ?LIST. For example, (&%ListOrderFn (&%ListFn &%Monday &%Tuesday &%Wednesday) 2) would return the value &%Tuesday.")
thf(ax_078,axiom,(
    ! [PROC: $i] :
      ( ( instance_THFTYPE_IiioI @ PROC @ lIntentionalProcess_THFTYPE_i )
     => ? [AGENT: $i] :
          ( ( instance_THFTYPE_IiioI @ AGENT @ lCognitiveAgent_THFTYPE_i )
          & ( agent_THFTYPE_IiioI @ PROC @ AGENT ) ) ) )).

thf(ax_079,axiom,(
    ! [REL2: $i,NUMBER: $i,CLASS1: $i,REL1: $i] :
      ( ( ( subrelation_THFTYPE_IiioI @ REL1 @ REL2 )
        & ( domainSubclass_THFTYPE_IiiioI @ REL2 @ NUMBER @ CLASS1 ) )
     => ( domainSubclass_THFTYPE_IiiioI @ REL1 @ NUMBER @ CLASS1 ) ) )).

thf(ax_080,axiom,
    ( subclass_THFTYPE_IiioI @ lAgent_THFTYPE_i @ lObject_THFTYPE_i )).

%KIF documentation:(documentation agent EnglishLanguage "(&%agent ?PROCESS ?AGENT) means that ?AGENT is an active determinant, either animate or inanimate, of the &%Process ?PROCESS, with or without voluntary intention. For example, Eve is an &%agent in the following proposition: Eve bit an apple.")
thf(ax_081,axiom,(
    ! [ATTR2: $i,ATTR1: $i] :
      ( ( ATTR1 = ATTR2 )
     => ! [THING: $i] :
          ( ( property_THFTYPE_IiioI @ THING @ ATTR1 )
        <=> ( property_THFTYPE_IiioI @ THING @ ATTR2 ) ) ) )).

thf(ax_082,axiom,
    ( likes_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBill_THFTYPE_i )).

thf(ax_083,axiom,(
    ! [SUBPROC: $i,PROC: $i] :
      ( ( subProcess_THFTYPE_IiioI @ SUBPROC @ PROC )
     => ! [REGION: $i] :
          ( ( located_THFTYPE_IiioI @ PROC @ REGION )
         => ( located_THFTYPE_IiioI @ SUBPROC @ REGION ) ) ) )).

%KIF documentation:(documentation ContentBearingObject EnglishLanguage "Any &%SelfConnectedObject that expresses content. This content may be a &%Proposition, e.g. when the &%ContentBearingObject is a &%Sentence or &%Text, or it may be a representation of an abstract or physical object, as with an &%Icon, a &%Word or a &%Phrase.")
%KIF documentation:(documentation BeginFn EnglishLanguage "A &%UnaryFunction that maps a &%TimeInterval to the &%TimePoint at which the interval begins.")
thf(ax_084,axiom,
    ( range_THFTYPE_IiioI @ lSubtractionFn_THFTYPE_i @ lQuantity_THFTYPE_i )).

%KIF documentation:(documentation Month EnglishLanguage "The &%Class of all calendar &%Months.")
%KIF documentation:(documentation EnglishLanguage EnglishLanguage "A Germanic language that incorporates many roots from the Romance languages. It is the official language of the &%UnitedStates, the &%UnitedKingdom, and many other countries.")
%KIF documentation:(documentation TransitiveRelation EnglishLanguage "A &%BinaryRelation ?REL is transitive if (?REL ?INST1 ?INST2) and (?REL ?INST2 ?INST3) imply (?REL ?INST1 ?INST3), for all ?INST1, ?INST2, and ?INST3.")
%KIF documentation:(documentation patient EnglishLanguage "(&%patient ?PROCESS ?ENTITY) means that ?ENTITY is a participant in ?PROCESS that may be moved, said, experienced, etc. For example, the direct objects in the sentences 'The cat swallowed the canary' and 'Billy likes the beer' would be examples of &%patients. Note that the &%patient of a &%Process may or may not undergo structural change as a result of the &%Process. The &%CaseRole of &%patient is used when one wants to specify as broadly as possible the object of a &%Process.")
%KIF documentation:(documentation believes EnglishLanguage "The epistemic predicate of belief. (&%believes ?AGENT ?FORMULA) means that ?AGENT believes the proposition expressed by ?FORMULA.")
%KIF documentation:(documentation Text EnglishLanguage "A &%LinguisticExpression or set of &%LinguisticExpressions that perform a specific function related to &%Communication, e.g. express a discourse about a particular topic, and that are inscribed in a &%CorpuscularObject by &%Humans.")
%KIF documentation:(documentation knows EnglishLanguage "The epistemic predicate of knowing. (&%knows ?AGENT ?FORMULA) means that ?AGENT knows the proposition expressed by ?FORMULA. Note that &%knows entails conscious awareness, so this &%Predicate cannot be used to express tacit or subconscious or unconscious knowledge.")
thf(ax_085,axiom,
    ( subclass_THFTYPE_IiioI @ lInternalAttribute_THFTYPE_i @ lAttribute_THFTYPE_i )).

%KIF documentation:(documentation Year EnglishLanguage "The &%Class of all calendar &%Years.")
%KIF documentation:(documentation result EnglishLanguage "(result ?ACTION ?OUTPUT) means that ?OUTPUT is a product of ?ACTION. For example, house is a &%result in the following proposition: Eric built a house.")
thf(ax_086,axiom,(
    ! [ATTR2: $i,ATTR1: $i] :
      ( ( subAttribute_THFTYPE_IiioI @ ATTR1 @ ATTR2 )
     => ! [OBJ: $i] :
          ( ( property_THFTYPE_IiioI @ OBJ @ ATTR1 )
         => ( property_THFTYPE_IiioI @ OBJ @ ATTR2 ) ) ) )).

%KIF documentation:(documentation SelfConnectedObject EnglishLanguage "A &%SelfConnectedObject is any &%Object that does not consist of two or more disconnected parts.")
thf(ax_087,axiom,
    ( range_THFTYPE_IiioI @ lAdditionFn_THFTYPE_i @ lQuantity_THFTYPE_i )).

%KIF documentation:(documentation temporalPart EnglishLanguage "The temporal analogue of the spatial &%part predicate. (&%temporalPart ?POS1 ?POS2) means that &%TimePosition ?POS1 is part of &%TimePosition ?POS2. Note that since &%temporalPart is a &%ReflexiveRelation every &%TimePostion is a &%temporalPart of itself.")
thf(ax_088,axiom,(
    ! [TEXT: $i] :
      ( ( instance_THFTYPE_IiioI @ TEXT @ lText_THFTYPE_i )
     => ? [PART: $i] :
          ( ( part_THFTYPE_IiioI @ PART @ TEXT )
          & ( instance_THFTYPE_IiioI @ PART @ lLinguisticExpression_THFTYPE_i ) ) ) )).

%KIF documentation:(documentation subrelation EnglishLanguage "(&%subrelation ?REL1 ?REL2) means that every tuple of ?REL1 is also a tuple of ?REL2. In other words, if the &%Relation ?REL1 holds for some arguments arg_1, arg_2, ... arg_n, then the &%Relation ?REL2 holds for the same arguments. A consequence of this is that a &%Relation and its subrelations must have the same &%valence.")
%KIF documentation:(documentation True EnglishLanguage "The &%TruthValue of being true.")
thf(ax_089,axiom,(
    ! [ROW: $i,ELEMENT: $i] :
      ( ( contraryAttribute_THFTYPE_IioI @ ROW )
     => ( ( inList_THFTYPE_IiioI @ ELEMENT @ ( lListFn_THFTYPE_IiiI @ ROW ) )
       => ( instance_THFTYPE_IiioI @ ELEMENT @ lAttribute_THFTYPE_i ) ) ) )).

%KIF documentation:(documentation EndFn EnglishLanguage "A &%UnaryFunction that maps a &%TimeInterval to the &%TimePoint at which the interval ends.")
%KIF documentation:(documentation meetsTemporally EnglishLanguage "(&%meetsTemporally ?INTERVAL1 ?INTERVAL2) means that the terminal point of the &%TimeInterval ?INTERVAL1 is the initial point of the &%TimeInterval ?INTERVAL2.")
thf(ax_090,axiom,(
    ! [OBJ: $i,PROCESS: $i] :
      ( ( located_THFTYPE_IiioI @ PROCESS @ OBJ )
     => ! [SUB: $i] :
          ( ( subProcess_THFTYPE_IiioI @ SUB @ PROCESS )
         => ( located_THFTYPE_IiioI @ SUB @ OBJ ) ) ) )).

thf(ax_091,axiom,
    ( subclass_THFTYPE_IiioI @ lUnaryFunction_THFTYPE_i @ lInheritableRelation_THFTYPE_i )).

%KIF documentation:(documentation partition EnglishLanguage "A &%partition of a class C is a set of mutually &%disjoint classes (a subclass partition) which covers C. Every instance of C is an instance of exactly one of the subclasses in the partition.")
%KIF documentation:(documentation containsInformation EnglishLanguage "A subrelation of &%represents. This predicate relates a &%ContentBearingPhysical to the &%Proposition that is expressed by the &%ContentBearingPhysical. Examples include the relationships between a physical novel and its story and between a printed score and its musical content.")
thf(ax_092,axiom,
    ( subclass_THFTYPE_IiioI @ lDay_THFTYPE_i @ lTimeInterval_THFTYPE_i )).

%KIF documentation:(documentation InternalAttribute EnglishLanguage "Any &%Attribute of an &%Entity that is an internal property of the &%Entity, e.g. its shape, its color, its fragility, etc.")
%KIF documentation:(documentation DayDuration EnglishLanguage "Time unit. 1 day = 24 hours.")
thf(ax_093,axiom,(
    ! [ROW2: $i,LIST2: $i,LIST1: $i,ROW1: $i] :
      ( ( LIST1 = LIST2 )
     => ( ( ( LIST1
            = ( lListFn_THFTYPE_IiiI @ ROW1 ) )
          & ( LIST2
            = ( lListFn_THFTYPE_IiiI @ ROW2 ) ) )
       => ! [NUMBER: $i] :
            ( ( lListOrderFn_THFTYPE_IiiiI @ ( lListFn_THFTYPE_IiiI @ ROW1 ) @ NUMBER )
            = ( lListOrderFn_THFTYPE_IiiiI @ ( lListFn_THFTYPE_IiiI @ ROW2 ) @ NUMBER ) ) ) ) )).

%KIF documentation:(documentation InheritableRelation EnglishLanguage "The class of &%Relations whose properties can be inherited downward in the class hierarchy via the &%subrelation &%Predicate.")
thf(ax_094,axiom,
    ( subclass_THFTYPE_IiioI @ lSentence_THFTYPE_i @ lLinguisticExpression_THFTYPE_i )).

thf(ax_095,axiom,(
    ! [REL2: $i,NUMBER: $i,CLASS1: $i,CLASS2: $i,REL1: $i] :
      ( ( ( domain_THFTYPE_IiiioI @ REL1 @ NUMBER @ CLASS1 )
        & ( domain_THFTYPE_IiiioI @ REL2 @ NUMBER @ CLASS2 )
        & ( disjoint_THFTYPE_IiioI @ CLASS1 @ CLASS2 ) )
     => ( disjointRelation_THFTYPE_IiioI @ REL1 @ REL2 ) ) )).

%KIF documentation:(documentation Attribute EnglishLanguage "Qualities which we cannot or choose not to reify into subclasses of &%Object.")
%KIF documentation:(documentation IntentionalProcess EnglishLanguage "A &%Process that has a specific purpose for the &%CognitiveAgent who performs it.")
%KIF documentation:(documentation Human EnglishLanguage "Modern man, the only remaining species of the Homo genus.")
thf(ax_096,axiom,
    ( rangeSubclass_THFTYPE_IiioI @ lYearFn_THFTYPE_i @ lYear_THFTYPE_i )).

thf(ax_097,axiom,(
    ! [CLASS: $i,PRED1: $i,PRED2: $i] :
      ( ( ( subrelation_THFTYPE_IiioI @ PRED1 @ PRED2 )
        & ( instance_THFTYPE_IiioI @ PRED2 @ CLASS )
        & ( subclass_THFTYPE_IiioI @ CLASS @ lInheritableRelation_THFTYPE_i ) )
     => ( instance_THFTYPE_IiioI @ PRED1 @ CLASS ) ) )).

thf(ax_098,axiom,(
    ! [ITEM: $i,LIST: $i] :
      ( ( inList_THFTYPE_IiioI @ ITEM @ LIST )
     => ? [NUMBER: $i] :
          ( ( lListOrderFn_THFTYPE_IiiiI @ LIST @ NUMBER )
          = ITEM ) ) )).

%KIF documentation:(documentation Object EnglishLanguage "Corresponds roughly to the class of ordinary objects. Examples include normal physical objects, geographical regions, and locations of &%Processes, the complement of &%Objects in the &%Physical class. In a 4D ontology, an &%Object is something whose spatiotemporal extent is thought of as dividing into spatial parts roughly parallel to the time-axis.")
thf(ax_099,axiom,(
    ! [CLASS1: $i,REL: $i,CLASS2: $i] :
      ( ( ( rangeSubclass_THFTYPE_IiioI @ REL @ CLASS1 )
        & ( rangeSubclass_THFTYPE_IiioI @ REL @ CLASS2 ) )
     => ( ( subclass_THFTYPE_IiioI @ CLASS1 @ CLASS2 )
        | ( subclass_THFTYPE_IiioI @ CLASS2 @ CLASS1 ) ) ) )).

thf(ax_100,axiom,
    ( subclass_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i @ lInheritableRelation_THFTYPE_i )).

thf(ax_101,axiom,
    ( instance_THFTYPE_IIiioIioI @ meetsTemporally_THFTYPE_IiioI @ lTemporalRelation_THFTYPE_i )).

thf(ax_102,axiom,
    ( instance_THFTYPE_IIiooIioI @ containsInformation_THFTYPE_IiooI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_103,axiom,
    ( instance_THFTYPE_IIiioIioI @ duration_THFTYPE_IiioI @ lTotalValuedRelation_THFTYPE_i )).

thf(ax_104,axiom,
    ( instance_THFTYPE_IiioI @ lAdditionFn_THFTYPE_i @ lBinaryFunction_THFTYPE_i )).

thf(ax_105,axiom,
    ( instance_THFTYPE_IiioI @ lMonthFn_THFTYPE_i @ lBinaryFunction_THFTYPE_i )).

thf(ax_106,axiom,
    ( instance_THFTYPE_IIiioIioI @ range_THFTYPE_IiioI @ lAsymmetricRelation_THFTYPE_i )).

thf(ax_107,axiom,
    ( domain_THFTYPE_IIiioIiioI @ disjointRelation_THFTYPE_IiioI @ n2_THFTYPE_i @ lRelation_THFTYPE_i )).

thf(ax_108,axiom,
    ( instance_THFTYPE_IIiioIioI @ meetsTemporally_THFTYPE_IiioI @ lAsymmetricRelation_THFTYPE_i )).

thf(ax_109,axiom,
    ( domainSubclass_THFTYPE_IiiioI @ lMonthFn_THFTYPE_i @ n2_THFTYPE_i @ lYear_THFTYPE_i )).

thf(ax_110,axiom,
    ( domain_THFTYPE_IIiioIiioI @ subProcess_THFTYPE_IiioI @ n1_THFTYPE_i @ lProcess_THFTYPE_i )).

thf(ax_111,axiom,
    ( relatedInternalConcept_THFTYPE_IiioI @ lMonth_THFTYPE_i @ lMonthFn_THFTYPE_i )).

thf(ax_112,axiom,
    ( instance_THFTYPE_IiioI @ lessThan_THFTYPE_i @ lBinaryPredicate_THFTYPE_i )).

thf(ax_113,axiom,
    ( domain_THFTYPE_IIiioIiioI @ meetsTemporally_THFTYPE_IiioI @ n1_THFTYPE_i @ lTimeInterval_THFTYPE_i )).

thf(ax_114,axiom,
    ( domain_THFTYPE_IiiioI @ equal_THFTYPE_i @ n2_THFTYPE_i @ lEntity_THFTYPE_i )).

thf(ax_115,axiom,
    ( domain_THFTYPE_IIoooIiioI @ truth_THFTYPE_IoooI @ n1_THFTYPE_i @ lSentence_THFTYPE_i )).

thf(ax_116,axiom,
    ( domain_THFTYPE_IIiioIiioI @ disjoint_THFTYPE_IiioI @ n2_THFTYPE_i @ lSetOrClass_THFTYPE_i )).

thf(ax_117,axiom,
    ( instance_THFTYPE_IiioI @ lSubtractionFn_THFTYPE_i @ lTotalValuedRelation_THFTYPE_i )).

thf(ax_118,axiom,
    ( domain_THFTYPE_IIiioIiioI @ subProcess_THFTYPE_IiioI @ n2_THFTYPE_i @ lProcess_THFTYPE_i )).

thf(ax_119,axiom,
    ( domain_THFTYPE_IIiioIiioI @ agent_THFTYPE_IiioI @ n1_THFTYPE_i @ lProcess_THFTYPE_i )).

thf(ax_120,axiom,
    ( instance_THFTYPE_IiioI @ equal_THFTYPE_i @ lBinaryPredicate_THFTYPE_i )).

thf(ax_121,axiom,
    ( instance_THFTYPE_IIiioIioI @ relatedInternalConcept_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_122,axiom,
    ( instance_THFTYPE_IiioI @ lAdditionFn_THFTYPE_i @ lRelationExtendedToQuantities_THFTYPE_i )).

thf(ax_123,axiom,
    ( instance_THFTYPE_IIiiiIioI @ lListOrderFn_THFTYPE_IiiiI @ lBinaryFunction_THFTYPE_i )).

thf(ax_124,axiom,
    ( instance_THFTYPE_IiioI @ lessThan_THFTYPE_i @ lIrreflexiveRelation_THFTYPE_i )).

thf(ax_125,axiom,
    ( relatedInternalConcept_THFTYPE_IiIiooIoI @ lContentBearingObject_THFTYPE_i @ containsInformation_THFTYPE_IiooI )).

thf(ax_126,axiom,
    ( domain_THFTYPE_IIiioIiioI @ disjointRelation_THFTYPE_IiioI @ n1_THFTYPE_i @ lRelation_THFTYPE_i )).

thf(ax_127,axiom,
    ( domain_THFTYPE_IiiioI @ greaterThan_THFTYPE_i @ n2_THFTYPE_i @ lQuantity_THFTYPE_i )).

thf(ax_128,axiom,
    ( domain_THFTYPE_IIiioIiioI @ range_THFTYPE_IiioI @ n2_THFTYPE_i @ lSetOrClass_THFTYPE_i )).

thf(ax_129,axiom,
    ( domain_THFTYPE_IIiioIiioI @ subrelation_THFTYPE_IiioI @ n2_THFTYPE_i @ lRelation_THFTYPE_i )).

thf(ax_130,axiom,
    ( instance_THFTYPE_IIiiIioI @ lYearFn_THFTYPE_IiiI @ lTemporalRelation_THFTYPE_i )).

thf(ax_131,axiom,
    ( instance_THFTYPE_IIiooIioI @ containsInformation_THFTYPE_IiooI @ lAsymmetricRelation_THFTYPE_i )).

thf(ax_132,axiom,
    ( instance_THFTYPE_IiioI @ attribute_THFTYPE_i @ lAsymmetricRelation_THFTYPE_i )).

thf(ax_133,axiom,
    ( instance_THFTYPE_IIiiIioI @ lWhenFn_THFTYPE_IiiI @ lUnaryFunction_THFTYPE_i )).

thf(ax_134,axiom,
    ( instance_THFTYPE_IiioI @ modalAttribute_THFTYPE_i @ lIrreflexiveRelation_THFTYPE_i )).

thf(ax_135,axiom,
    ( subrelation_THFTYPE_IiioI @ result_THFTYPE_i @ patient_THFTYPE_i )).

thf(ax_136,axiom,
    ( domain_THFTYPE_IiiioI @ patient_THFTYPE_i @ n1_THFTYPE_i @ lProcess_THFTYPE_i )).

thf(ax_137,axiom,
    ( domain_THFTYPE_IiiioI @ lMultiplicationFn_THFTYPE_i @ n1_THFTYPE_i @ lQuantity_THFTYPE_i )).

thf(ax_138,axiom,
    ( domain_THFTYPE_IIiooIiioI @ believes_THFTYPE_IiooI @ n2_THFTYPE_i @ lFormula_THFTYPE_i )).

thf(ax_139,axiom,
    ( instance_THFTYPE_IIiiIioI @ lCardinalityFn_THFTYPE_IiiI @ lUnaryFunction_THFTYPE_i )).

thf(ax_140,axiom,
    ( instance_THFTYPE_IiioI @ greaterThan_THFTYPE_i @ lRelationExtendedToQuantities_THFTYPE_i )).

thf(ax_141,axiom,
    ( instance_THFTYPE_IiioI @ lMultiplicationFn_THFTYPE_i @ lTotalValuedRelation_THFTYPE_i )).

thf(ax_142,axiom,
    ( domain_THFTYPE_IIiioIiioI @ property_THFTYPE_IiioI @ n2_THFTYPE_i @ lAttribute_THFTYPE_i )).

thf(ax_143,axiom,
    ( domain_THFTYPE_IiiioI @ patient_THFTYPE_i @ n2_THFTYPE_i @ lEntity_THFTYPE_i )).

thf(ax_144,axiom,
    ( domain_THFTYPE_IIiioIiioI @ member_THFTYPE_IiioI @ n1_THFTYPE_i @ lSelfConnectedObject_THFTYPE_i )).

thf(ax_145,axiom,
    ( domain_THFTYPE_IIiioIiioI @ subAttribute_THFTYPE_IiioI @ n1_THFTYPE_i @ lAttribute_THFTYPE_i )).

thf(ax_146,axiom,
    ( domain_THFTYPE_IIiiioIiioI @ orientation_THFTYPE_IiiioI @ n3_THFTYPE_i @ lPositionalAttribute_THFTYPE_i )).

thf(ax_147,axiom,
    ( instance_THFTYPE_IiioI @ documentation_THFTYPE_i @ lTernaryPredicate_THFTYPE_i )).

thf(ax_148,axiom,
    ( instance_THFTYPE_IIiioIioI @ inList_THFTYPE_IiioI @ lAsymmetricRelation_THFTYPE_i )).

thf(ax_149,axiom,
    ( instance_THFTYPE_IIiioIioI @ duration_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_150,axiom,
    ( domain_THFTYPE_IIiooIiioI @ knows_THFTYPE_IiooI @ n2_THFTYPE_i @ lFormula_THFTYPE_i )).

thf(ax_151,axiom,
    ( instance_THFTYPE_IIiiioIioI @ orientation_THFTYPE_IiiioI @ lTernaryPredicate_THFTYPE_i )).

thf(ax_152,axiom,
    ( domain_THFTYPE_IIiiioIiioI @ domain_THFTYPE_IiiioI @ n1_THFTYPE_i @ lRelation_THFTYPE_i )).

thf(ax_153,axiom,
    ( instance_THFTYPE_IiioI @ greaterThan_THFTYPE_i @ lIrreflexiveRelation_THFTYPE_i )).

thf(ax_154,axiom,
    ( instance_THFTYPE_IIiooIioI @ knows_THFTYPE_IiooI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_155,axiom,
    ( domain_THFTYPE_IiiioI @ result_THFTYPE_i @ n2_THFTYPE_i @ lEntity_THFTYPE_i )).

thf(ax_156,axiom,
    ( instance_THFTYPE_IiioI @ lMultiplicationFn_THFTYPE_i @ lRelationExtendedToQuantities_THFTYPE_i )).

thf(ax_157,axiom,
    ( instance_THFTYPE_IIiiiIioI @ lTemporalCompositionFn_THFTYPE_IiiiI @ lTemporalRelation_THFTYPE_i )).

thf(ax_158,axiom,
    ( domain_THFTYPE_IIiioIiioI @ relatedInternalConcept_THFTYPE_IiioI @ n2_THFTYPE_i @ lEntity_THFTYPE_i )).

thf(ax_159,axiom,
    ( instance_THFTYPE_IIiioIioI @ subrelation_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_160,axiom,
    ( relatedInternalConcept_THFTYPE_IIiioIIiioIoI @ disjointRelation_THFTYPE_IiioI @ disjoint_THFTYPE_IiioI )).

thf(ax_161,axiom,
    ( domain_THFTYPE_IiiioI @ greaterThan_THFTYPE_i @ n1_THFTYPE_i @ lQuantity_THFTYPE_i )).

thf(ax_162,axiom,
    ( subrelation_THFTYPE_IIiioIIiioIoI @ member_THFTYPE_IiioI @ part_THFTYPE_IiioI )).

thf(ax_163,axiom,
    ( domain_THFTYPE_IIiioIiioI @ part_THFTYPE_IiioI @ n1_THFTYPE_i @ lObject_THFTYPE_i )).

thf(ax_164,axiom,
    ( instance_THFTYPE_IIiiIioI @ lBeginFn_THFTYPE_IiiI @ lTemporalRelation_THFTYPE_i )).

thf(ax_165,axiom,
    ( domain_THFTYPE_IIiiIiioI @ lBeginFn_THFTYPE_IiiI @ n1_THFTYPE_i @ lTimeInterval_THFTYPE_i )).

thf(ax_166,axiom,
    ( instance_THFTYPE_IiioI @ lSubtractionFn_THFTYPE_i @ lRelationExtendedToQuantities_THFTYPE_i )).

thf(ax_167,axiom,
    ( domain_THFTYPE_IIiioIiioI @ property_THFTYPE_IiioI @ n1_THFTYPE_i @ lEntity_THFTYPE_i )).

thf(ax_168,axiom,
    ( instance_THFTYPE_IIiioIioI @ instance_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_169,axiom,
    ( instance_THFTYPE_IiioI @ attribute_THFTYPE_i @ lIrreflexiveRelation_THFTYPE_i )).

thf(ax_170,axiom,
    ( instance_THFTYPE_IIiooIioI @ holdsDuring_THFTYPE_IiooI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_171,axiom,
    ( domain_THFTYPE_IIiioIiioI @ instance_THFTYPE_IiioI @ n1_THFTYPE_i @ lEntity_THFTYPE_i )).

thf(ax_172,axiom,
    ( domain_THFTYPE_IiiioI @ lessThan_THFTYPE_i @ n1_THFTYPE_i @ lQuantity_THFTYPE_i )).

thf(ax_173,axiom,
    ( instance_THFTYPE_IoioI @ $true @ lTruthValue_THFTYPE_i )).

thf(ax_174,axiom,
    ( domain_THFTYPE_IIiioIiioI @ part_THFTYPE_IiioI @ n2_THFTYPE_i @ lObject_THFTYPE_i )).

thf(ax_175,axiom,
    ( instance_THFTYPE_IIiioIioI @ temporalPart_THFTYPE_IiioI @ lTemporalRelation_THFTYPE_i )).

thf(ax_176,axiom,
    ( subrelation_THFTYPE_IiIiioIoI @ modalAttribute_THFTYPE_i @ property_THFTYPE_IiioI )).

thf(ax_177,axiom,
    ( domain_THFTYPE_IiiioI @ instrument_THFTYPE_i @ n2_THFTYPE_i @ lObject_THFTYPE_i )).

thf(ax_178,axiom,
    ( domain_THFTYPE_IiiioI @ lAdditionFn_THFTYPE_i @ n1_THFTYPE_i @ lQuantity_THFTYPE_i )).

thf(ax_179,axiom,
    ( domain_THFTYPE_IIiiIiioI @ lYearFn_THFTYPE_IiiI @ n1_THFTYPE_i @ lInteger_THFTYPE_i )).

thf(ax_180,axiom,
    ( instance_THFTYPE_IIiioIioI @ range_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_181,axiom,
    ( instance_THFTYPE_IIIiioIiioIioI @ domain_THFTYPE_IIiioIiioI @ lTernaryPredicate_THFTYPE_i )).

thf(ax_182,axiom,
    ( domain_THFTYPE_IIiiioIiioI @ domain_THFTYPE_IiiioI @ n3_THFTYPE_i @ lSetOrClass_THFTYPE_i )).

thf(ax_183,axiom,
    ( instance_THFTYPE_IIiioIioI @ inList_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_184,axiom,
    ( instance_THFTYPE_IIiiIioI @ lCardinalityFn_THFTYPE_IiiI @ lTotalValuedRelation_THFTYPE_i )).

thf(ax_185,axiom,
    ( domain_THFTYPE_IiiioI @ documentation_THFTYPE_i @ n1_THFTYPE_i @ lEntity_THFTYPE_i )).

thf(ax_186,axiom,
    ( instance_THFTYPE_IIiioIioI @ rangeSubclass_THFTYPE_IiioI @ lAsymmetricRelation_THFTYPE_i )).

thf(ax_187,axiom,
    ( relatedInternalConcept_THFTYPE_IiIiiIoI @ lYear_THFTYPE_i @ lYearFn_THFTYPE_IiiI )).

thf(ax_188,axiom,
    ( domain_THFTYPE_IiiioI @ equal_THFTYPE_i @ n1_THFTYPE_i @ lEntity_THFTYPE_i )).

thf(ax_189,axiom,
    ( instance_THFTYPE_IIiiIioI @ lCardinalityFn_THFTYPE_IiiI @ lAsymmetricRelation_THFTYPE_i )).

thf(ax_190,axiom,
    ( instance_THFTYPE_IIiioIioI @ disjoint_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_191,axiom,
    ( subrelation_THFTYPE_IiIiioIoI @ attribute_THFTYPE_i @ property_THFTYPE_IiioI )).

thf(ax_192,axiom,
    ( instance_THFTYPE_IIiioIioI @ temporalPart_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_193,axiom,
    ( instance_THFTYPE_IiioI @ lMultiplicationFn_THFTYPE_i @ lBinaryFunction_THFTYPE_i )).

thf(ax_194,axiom,
    ( domain_THFTYPE_IIiioIiioI @ inList_THFTYPE_IiioI @ n2_THFTYPE_i @ lList_THFTYPE_i )).

thf(ax_195,axiom,
    ( instance_THFTYPE_IIiioIioI @ subProcess_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_196,axiom,
    ( instance_THFTYPE_IiioI @ greaterThan_THFTYPE_i @ lTransitiveRelation_THFTYPE_i )).

thf(ax_197,axiom,
    ( instance_THFTYPE_IoioI @ $false @ lTruthValue_THFTYPE_i )).

thf(ax_198,axiom,
    ( instance_THFTYPE_IIiioIioI @ disjointRelation_THFTYPE_IiioI @ lIrreflexiveRelation_THFTYPE_i )).

thf(ax_199,axiom,
    ( instance_THFTYPE_IiioI @ lMonthFn_THFTYPE_i @ lTemporalRelation_THFTYPE_i )).

thf(ax_200,axiom,
    ( domain_THFTYPE_IIiooIiioI @ holdsDuring_THFTYPE_IiooI @ n2_THFTYPE_i @ lFormula_THFTYPE_i )).

thf(ax_201,axiom,
    ( instance_THFTYPE_IiioI @ greaterThan_THFTYPE_i @ lBinaryPredicate_THFTYPE_i )).

thf(ax_202,axiom,
    ( instance_THFTYPE_IIiiIioI @ lBeginFn_THFTYPE_IiiI @ lUnaryFunction_THFTYPE_i )).

thf(ax_203,axiom,
    ( instance_THFTYPE_IIiiiIioI @ lMeasureFn_THFTYPE_IiiiI @ lBinaryFunction_THFTYPE_i )).

thf(ax_204,axiom,
    ( domain_THFTYPE_IIiioIiioI @ inList_THFTYPE_IiioI @ n1_THFTYPE_i @ lEntity_THFTYPE_i )).

thf(ax_205,axiom,
    ( domain_THFTYPE_IiiioI @ lMultiplicationFn_THFTYPE_i @ n2_THFTYPE_i @ lQuantity_THFTYPE_i )).

thf(ax_206,axiom,
    ( instance_THFTYPE_IIiiIioI @ lBeginFn_THFTYPE_IiiI @ lTotalValuedRelation_THFTYPE_i )).

thf(ax_207,axiom,
    ( instance_THFTYPE_IIiioIioI @ meetsTemporally_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_208,axiom,
    ( domainSubclass_THFTYPE_IiiioI @ lMonthFn_THFTYPE_i @ n1_THFTYPE_i @ lMonth_THFTYPE_i )).

thf(ax_209,axiom,
    ( instance_THFTYPE_IIiioIioI @ subclass_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_210,axiom,
    ( domain_THFTYPE_IIiioIiioI @ subAttribute_THFTYPE_IiioI @ n2_THFTYPE_i @ lAttribute_THFTYPE_i )).

thf(ax_211,axiom,
    ( domain_THFTYPE_IiiioI @ result_THFTYPE_i @ n1_THFTYPE_i @ lProcess_THFTYPE_i )).

thf(ax_212,axiom,
    ( instance_THFTYPE_IIiiIioI @ lEndFn_THFTYPE_IiiI @ lUnaryFunction_THFTYPE_i )).

thf(ax_213,axiom,
    ( instance_THFTYPE_IIiioIioI @ inList_THFTYPE_IiioI @ lIrreflexiveRelation_THFTYPE_i )).

thf(ax_214,axiom,
    ( domain_THFTYPE_IIiioIiioI @ subclass_THFTYPE_IiioI @ n2_THFTYPE_i @ lSetOrClass_THFTYPE_i )).

thf(ax_215,axiom,
    ( instance_THFTYPE_IIiooIioI @ believes_THFTYPE_IiooI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_216,axiom,
    ( domain_THFTYPE_IIiooIiioI @ believes_THFTYPE_IiooI @ n1_THFTYPE_i @ lCognitiveAgent_THFTYPE_i )).

thf(ax_217,axiom,
    ( instance_THFTYPE_IIiiIioI @ lEndFn_THFTYPE_IiiI @ lTemporalRelation_THFTYPE_i )).

thf(ax_218,axiom,
    ( domain_THFTYPE_IIiiiIiioI @ lTemporalCompositionFn_THFTYPE_IiiiI @ n1_THFTYPE_i @ lTimeInterval_THFTYPE_i )).

thf(ax_219,axiom,
    ( domain_THFTYPE_IIiioIiioI @ relatedInternalConcept_THFTYPE_IiioI @ n1_THFTYPE_i @ lEntity_THFTYPE_i )).

thf(ax_220,axiom,
    ( instance_THFTYPE_IIiiiIioI @ lTemporalCompositionFn_THFTYPE_IiiiI @ lBinaryFunction_THFTYPE_i )).

thf(ax_221,axiom,
    ( domain_THFTYPE_IIiioIiioI @ subclass_THFTYPE_IiioI @ n1_THFTYPE_i @ lSetOrClass_THFTYPE_i )).

thf(ax_222,axiom,
    ( domain_THFTYPE_IiiioI @ lSubtractionFn_THFTYPE_i @ n2_THFTYPE_i @ lQuantity_THFTYPE_i )).

thf(ax_223,axiom,
    ( instance_THFTYPE_IiioI @ equal_THFTYPE_i @ lRelationExtendedToQuantities_THFTYPE_i )).

thf(ax_224,axiom,
    ( domainSubclass_THFTYPE_IIiiiIiioI @ lTemporalCompositionFn_THFTYPE_IiiiI @ n2_THFTYPE_i @ lTimeInterval_THFTYPE_i )).

thf(ax_225,axiom,
    ( domain_THFTYPE_IIiooIiioI @ containsInformation_THFTYPE_IiooI @ n2_THFTYPE_i @ lProposition_THFTYPE_i )).

thf(ax_226,axiom,
    ( instance_THFTYPE_IIiiIioI @ lYearFn_THFTYPE_IiiI @ lUnaryFunction_THFTYPE_i )).

thf(ax_227,axiom,
    ( domain_THFTYPE_IIiiioIiioI @ orientation_THFTYPE_IiiioI @ n2_THFTYPE_i @ lObject_THFTYPE_i )).

thf(ax_228,axiom,
    ( relatedInternalConcept_THFTYPE_IiioI @ lDay_THFTYPE_i @ lDayDuration_THFTYPE_i )).

thf(ax_229,axiom,
    ( domain_THFTYPE_IIIioIiioIiioI @ domainSubclass_THFTYPE_IIioIiioI @ n1_THFTYPE_i @ lRelation_THFTYPE_i )).

thf(ax_230,axiom,
    ( disjointRelation_THFTYPE_IiioI @ result_THFTYPE_i @ instrument_THFTYPE_i )).

thf(ax_231,axiom,
    ( instance_THFTYPE_IIiiiIioI @ lMeasureFn_THFTYPE_IiiiI @ lTotalValuedRelation_THFTYPE_i )).

thf(ax_232,axiom,
    ( domain_THFTYPE_IiiioI @ instrument_THFTYPE_i @ n1_THFTYPE_i @ lProcess_THFTYPE_i )).

thf(ax_233,axiom,
    ( instance_THFTYPE_IIiioIioI @ duration_THFTYPE_IiioI @ lAsymmetricRelation_THFTYPE_i )).

thf(ax_234,axiom,
    ( instance_THFTYPE_IiioI @ lAdditionFn_THFTYPE_i @ lTotalValuedRelation_THFTYPE_i )).

thf(ax_235,axiom,
    ( domain_THFTYPE_IIoooIiioI @ truth_THFTYPE_IoooI @ n2_THFTYPE_i @ lTruthValue_THFTYPE_i )).

thf(ax_236,axiom,
    ( instance_THFTYPE_IiioI @ lSubtractionFn_THFTYPE_i @ lBinaryFunction_THFTYPE_i )).

thf(ax_237,axiom,
    ( domain_THFTYPE_IIiioIiioI @ instance_THFTYPE_IiioI @ n2_THFTYPE_i @ lSetOrClass_THFTYPE_i )).

thf(ax_238,axiom,
    ( instance_THFTYPE_IIiioIioI @ subAttribute_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_239,axiom,
    ( domain_THFTYPE_IiiioI @ lSubtractionFn_THFTYPE_i @ n1_THFTYPE_i @ lQuantity_THFTYPE_i )).

thf(ax_240,axiom,
    ( domain_THFTYPE_IIiioIiioI @ duration_THFTYPE_IiioI @ n1_THFTYPE_i @ lTimeInterval_THFTYPE_i )).

thf(ax_241,axiom,
    ( instance_THFTYPE_IIiioIioI @ member_THFTYPE_IiioI @ lAsymmetricRelation_THFTYPE_i )).

thf(ax_242,axiom,
    ( domain_THFTYPE_IIiioIiioI @ subrelation_THFTYPE_IiioI @ n1_THFTYPE_i @ lRelation_THFTYPE_i )).

thf(ax_243,axiom,
    ( instance_THFTYPE_IIiiIioI @ lEndFn_THFTYPE_IiiI @ lTotalValuedRelation_THFTYPE_i )).

thf(ax_244,axiom,
    ( instance_THFTYPE_IIIioIiioIioI @ domainSubclass_THFTYPE_IIioIiioI @ lTernaryPredicate_THFTYPE_i )).

thf(ax_245,axiom,
    ( domain_THFTYPE_IIiioIiioI @ agent_THFTYPE_IiioI @ n2_THFTYPE_i @ lAgent_THFTYPE_i )).

thf(ax_246,axiom,
    ( instance_THFTYPE_IIiioIioI @ property_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_247,axiom,
    ( domain_THFTYPE_IIiiiIiioI @ lListOrderFn_THFTYPE_IiiiI @ n1_THFTYPE_i @ lList_THFTYPE_i )).

thf(ax_248,axiom,
    ( domain_THFTYPE_IIiioIiioI @ meetsTemporally_THFTYPE_IiioI @ n2_THFTYPE_i @ lTimeInterval_THFTYPE_i )).

thf(ax_249,axiom,
    ( domain_THFTYPE_IiiioI @ lessThan_THFTYPE_i @ n2_THFTYPE_i @ lQuantity_THFTYPE_i )).

thf(ax_250,axiom,
    ( instance_THFTYPE_IIiooIioI @ holdsDuring_THFTYPE_IiooI @ lAsymmetricRelation_THFTYPE_i )).

thf(ax_251,axiom,
    ( domainSubclass_THFTYPE_IIiioIiioI @ rangeSubclass_THFTYPE_IiioI @ n2_THFTYPE_i @ lSetOrClass_THFTYPE_i )).

thf(ax_252,axiom,
    ( instance_THFTYPE_IiioI @ lessThan_THFTYPE_i @ lTransitiveRelation_THFTYPE_i )).

thf(ax_253,axiom,
    ( relatedInternalConcept_THFTYPE_IIiioIIiioIoI @ member_THFTYPE_IiioI @ instance_THFTYPE_IiioI )).

thf(ax_254,axiom,
    ( domain_THFTYPE_IiiioI @ modalAttribute_THFTYPE_i @ n1_THFTYPE_i @ lFormula_THFTYPE_i )).

thf(ax_255,axiom,
    ( domain_THFTYPE_IIiioIiioI @ disjoint_THFTYPE_IiioI @ n1_THFTYPE_i @ lSetOrClass_THFTYPE_i )).

thf(ax_256,axiom,
    ( subrelation_THFTYPE_IiioI @ instrument_THFTYPE_i @ patient_THFTYPE_i )).

thf(ax_257,axiom,
    ( domain_THFTYPE_IIiooIiioI @ knows_THFTYPE_IiooI @ n1_THFTYPE_i @ lCognitiveAgent_THFTYPE_i )).

thf(ax_258,axiom,
    ( domain_THFTYPE_IIiiIiioI @ lEndFn_THFTYPE_IiiI @ n1_THFTYPE_i @ lTimeInterval_THFTYPE_i )).

thf(ax_259,axiom,
    ( instance_THFTYPE_IIiioIioI @ disjointRelation_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_260,axiom,
    ( domain_THFTYPE_IIiiioIiioI @ orientation_THFTYPE_IiiioI @ n1_THFTYPE_i @ lObject_THFTYPE_i )).

thf(ax_261,axiom,
    ( instance_THFTYPE_IIiiIioI @ lWhenFn_THFTYPE_IiiI @ lTotalValuedRelation_THFTYPE_i )).

thf(ax_262,axiom,
    ( instance_THFTYPE_IiioI @ lessThan_THFTYPE_i @ lRelationExtendedToQuantities_THFTYPE_i )).

thf(ax_263,axiom,
    ( instance_THFTYPE_IiioI @ modalAttribute_THFTYPE_i @ lBinaryPredicate_THFTYPE_i )).

thf(ax_264,axiom,
    ( domain_THFTYPE_IiiioI @ attribute_THFTYPE_i @ n1_THFTYPE_i @ lObject_THFTYPE_i )).

thf(ax_265,axiom,
    ( subrelation_THFTYPE_IIoooIIiioIoI @ truth_THFTYPE_IoooI @ property_THFTYPE_IiioI )).

thf(ax_266,axiom,
    ( domain_THFTYPE_IiiioI @ lAdditionFn_THFTYPE_i @ n2_THFTYPE_i @ lQuantity_THFTYPE_i )).

thf(ax_267,axiom,
    ( instance_THFTYPE_IIiioIioI @ located_THFTYPE_IiioI @ lTransitiveRelation_THFTYPE_i )).

thf(ax_268,axiom,
    ( instance_THFTYPE_IiioI @ modalAttribute_THFTYPE_i @ lAsymmetricRelation_THFTYPE_i )).

thf(ax_269,axiom,
    ( domain_THFTYPE_IIIioIiioIiioI @ domainSubclass_THFTYPE_IIioIiioI @ n3_THFTYPE_i @ lSetOrClass_THFTYPE_i )).

thf(ax_270,axiom,
    ( instance_THFTYPE_IIiioIioI @ rangeSubclass_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i )).

thf(ax_271,axiom,
    ( instance_THFTYPE_IIiiIioI @ lWhenFn_THFTYPE_IiiI @ lTemporalRelation_THFTYPE_i )).

%----The translated conjecture
thf(con,conjecture,
    ( holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i ) @ $false )).

%------------------------------------------------------------------------------
